/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatThreadPropertiesUpdatedEventData
extends AcsChatThreadEventInThreadBaseProperties {
    private CommunicationIdentifierModel editedByCommunicationIdentifier;
    private OffsetDateTime editTime;
    private Map<String, Object> properties;
    private Map<String, String> metadata;

    public CommunicationIdentifierModel getEditedByCommunicationIdentifier() {
        return this.editedByCommunicationIdentifier;
    }

    public AcsChatThreadPropertiesUpdatedEventData setEditedByCommunicationIdentifier(CommunicationIdentifierModel editedByCommunicationIdentifier) {
        this.editedByCommunicationIdentifier = editedByCommunicationIdentifier;
        return this;
    }

    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    public AcsChatThreadPropertiesUpdatedEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AcsChatThreadPropertiesUpdatedEventData setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatThreadPropertiesUpdatedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public AcsChatThreadPropertiesUpdatedEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    @Override
    public AcsChatThreadPropertiesUpdatedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatThreadPropertiesUpdatedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatThreadPropertiesUpdatedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("createTime", this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeJsonField("editedByCommunicationIdentifier", (JsonSerializable)this.editedByCommunicationIdentifier);
        jsonWriter.writeStringField("editTime", this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatThreadPropertiesUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatThreadPropertiesUpdatedEventData)jsonReader.readObject(reader -> {
            AcsChatThreadPropertiesUpdatedEventData deserializedAcsChatThreadPropertiesUpdatedEventData = new AcsChatThreadPropertiesUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setCreateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("editedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.editedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("editTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.editTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedAcsChatThreadPropertiesUpdatedEventData.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatThreadPropertiesUpdatedEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatThreadPropertiesUpdatedEventData;
        });
    }
}

