/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRecordingStorageInfoProperties;
import com.azure.messaging.eventgrid.systemevents.RecordingChannelType;
import com.azure.messaging.eventgrid.systemevents.RecordingContentType;
import com.azure.messaging.eventgrid.systemevents.RecordingFormatType;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsRecordingFileStatusUpdatedEventData
implements JsonSerializable<AcsRecordingFileStatusUpdatedEventData> {
    private AcsRecordingStorageInfoProperties recordingStorageInfo;
    private OffsetDateTime recordingStartTime;
    private Long recordingDurationMs;
    private RecordingContentType recordingContentType;
    private RecordingChannelType recordingChannelType;
    private RecordingFormatType recordingFormatType;
    private String sessionEndReason;

    public AcsRecordingStorageInfoProperties getRecordingStorageInfo() {
        return this.recordingStorageInfo;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingStorageInfo(AcsRecordingStorageInfoProperties recordingStorageInfo) {
        this.recordingStorageInfo = recordingStorageInfo;
        return this;
    }

    public OffsetDateTime getRecordingStartTime() {
        return this.recordingStartTime;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingStartTime(OffsetDateTime recordingStartTime) {
        this.recordingStartTime = recordingStartTime;
        return this;
    }

    public Duration getRecordingDuration() {
        if (this.recordingDurationMs != null) {
            return Duration.ofMillis(this.recordingDurationMs);
        }
        return null;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingDuration(Duration recordingDuration) {
        this.recordingDurationMs = recordingDuration != null ? Long.valueOf(recordingDuration.toMillis()) : null;
        return this;
    }

    public RecordingContentType getRecordingContentType() {
        return this.recordingContentType;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingContentType(RecordingContentType recordingContentType) {
        this.recordingContentType = recordingContentType;
        return this;
    }

    public RecordingChannelType getRecordingChannelType() {
        return this.recordingChannelType;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingChannelType(RecordingChannelType recordingChannelType) {
        this.recordingChannelType = recordingChannelType;
        return this;
    }

    public RecordingFormatType getRecordingFormatType() {
        return this.recordingFormatType;
    }

    public AcsRecordingFileStatusUpdatedEventData setRecordingFormatType(RecordingFormatType recordingFormatType) {
        this.recordingFormatType = recordingFormatType;
        return this;
    }

    public String getSessionEndReason() {
        return this.sessionEndReason;
    }

    public AcsRecordingFileStatusUpdatedEventData setSessionEndReason(String sessionEndReason) {
        this.sessionEndReason = sessionEndReason;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recordingStorageInfo", (JsonSerializable)this.recordingStorageInfo);
        jsonWriter.writeStringField("recordingStartTime", this.recordingStartTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.recordingStartTime));
        jsonWriter.writeNumberField("recordingDurationMs", (Number)this.recordingDurationMs);
        jsonWriter.writeStringField("recordingContentType", this.recordingContentType == null ? null : this.recordingContentType.toString());
        jsonWriter.writeStringField("recordingChannelType", this.recordingChannelType == null ? null : this.recordingChannelType.toString());
        jsonWriter.writeStringField("recordingFormatType", this.recordingFormatType == null ? null : this.recordingFormatType.toString());
        jsonWriter.writeStringField("sessionEndReason", this.sessionEndReason);
        return jsonWriter.writeEndObject();
    }

    public static AcsRecordingFileStatusUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRecordingFileStatusUpdatedEventData)jsonReader.readObject(reader -> {
            AcsRecordingFileStatusUpdatedEventData deserializedAcsRecordingFileStatusUpdatedEventData = new AcsRecordingFileStatusUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordingStorageInfo".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingStorageInfo = AcsRecordingStorageInfoProperties.fromJson(reader);
                    continue;
                }
                if ("recordingStartTime".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("recordingDurationMs".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingDurationMs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recordingContentType".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingContentType = RecordingContentType.fromString(reader.getString());
                    continue;
                }
                if ("recordingChannelType".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingChannelType = RecordingChannelType.fromString(reader.getString());
                    continue;
                }
                if ("recordingFormatType".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.recordingFormatType = RecordingFormatType.fromString(reader.getString());
                    continue;
                }
                if ("sessionEndReason".equals(fieldName)) {
                    deserializedAcsRecordingFileStatusUpdatedEventData.sessionEndReason = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRecordingFileStatusUpdatedEventData;
        });
    }
}

