/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AcsRouterJobQueuedEventData
extends AcsRouterJobEventData {
    private Integer priority;
    private List<AcsRouterWorkerSelector> attachedWorkerSelectors;
    private List<AcsRouterWorkerSelector> requestedWorkerSelectors;

    public Integer getPriority() {
        return this.priority;
    }

    public AcsRouterJobQueuedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<AcsRouterWorkerSelector> getAttachedWorkerSelectors() {
        return this.attachedWorkerSelectors;
    }

    public AcsRouterJobQueuedEventData setAttachedWorkerSelectors(List<AcsRouterWorkerSelector> attachedWorkerSelectors) {
        this.attachedWorkerSelectors = attachedWorkerSelectors;
        return this;
    }

    public List<AcsRouterWorkerSelector> getRequestedWorkerSelectors() {
        return this.requestedWorkerSelectors;
    }

    public AcsRouterJobQueuedEventData setRequestedWorkerSelectors(List<AcsRouterWorkerSelector> requestedWorkerSelectors) {
        this.requestedWorkerSelectors = requestedWorkerSelectors;
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobQueuedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("attachedWorkerSelectors", this.attachedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("requestedWorkerSelectors", this.requestedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobQueuedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobQueuedEventData)jsonReader.readObject(reader -> {
            AcsRouterJobQueuedEventData deserializedAcsRouterJobQueuedEventData = new AcsRouterJobQueuedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobQueuedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobQueuedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobQueuedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobQueuedEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobQueuedEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobQueuedEventData.setTags(tags);
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobQueuedEventData.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("attachedWorkerSelectors".equals(fieldName)) {
                    List attachedWorkerSelectors;
                    deserializedAcsRouterJobQueuedEventData.attachedWorkerSelectors = attachedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("requestedWorkerSelectors".equals(fieldName)) {
                    List requestedWorkerSelectors;
                    deserializedAcsRouterJobQueuedEventData.requestedWorkerSelectors = requestedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobQueuedEventData;
        });
    }
}

