/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryArtifactEventData;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryArtifactEventTarget;
import com.azure.messaging.eventgrid.systemevents.ContainerRegistryEventConnectedRegistry;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ContainerRegistryChartPushedEventData
extends ContainerRegistryArtifactEventData {
    @Override
    public ContainerRegistryChartPushedEventData setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public ContainerRegistryChartPushedEventData setTimestamp(OffsetDateTime timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public ContainerRegistryChartPushedEventData setAction(String action) {
        super.setAction(action);
        return this;
    }

    @Override
    public ContainerRegistryChartPushedEventData setLocation(String location) {
        super.setLocation(location);
        return this;
    }

    @Override
    public ContainerRegistryChartPushedEventData setTarget(ContainerRegistryArtifactEventTarget target) {
        super.setTarget(target);
        return this;
    }

    @Override
    public ContainerRegistryChartPushedEventData setConnectedRegistry(ContainerRegistryEventConnectedRegistry connectedRegistry) {
        super.setConnectedRegistry(connectedRegistry);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeStringField("timestamp", this.getTimestamp() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getTimestamp()));
        jsonWriter.writeStringField("action", this.getAction());
        jsonWriter.writeStringField("location", this.getLocation());
        jsonWriter.writeJsonField("target", (JsonSerializable)this.getTarget());
        jsonWriter.writeJsonField("connectedRegistry", (JsonSerializable)this.getConnectedRegistry());
        return jsonWriter.writeEndObject();
    }

    public static ContainerRegistryChartPushedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerRegistryChartPushedEventData)jsonReader.readObject(reader -> {
            ContainerRegistryChartPushedEventData deserializedContainerRegistryChartPushedEventData = new ContainerRegistryChartPushedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setId(reader.getString());
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setTimestamp((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setAction(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setLocation(reader.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setTarget(ContainerRegistryArtifactEventTarget.fromJson(reader));
                    continue;
                }
                if ("connectedRegistry".equals(fieldName)) {
                    deserializedContainerRegistryChartPushedEventData.setConnectedRegistry(ContainerRegistryEventConnectedRegistry.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerRegistryChartPushedEventData;
        });
    }
}

