/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MediaLiveEventIngestHeartbeatEventData
implements JsonSerializable<MediaLiveEventIngestHeartbeatEventData> {
    private String trackType;
    private String trackName;
    private String transcriptionLanguage;
    private String transcriptionState;
    private Long bitrate;
    private Long incomingBitrate;
    private String ingestDriftValue;
    private String lastFragmentArrivalTime;
    private String lastTimestamp;
    private String timescale;
    private Long overlapCount;
    private Long discontinuityCount;
    private Long nonincreasingCount;
    private Boolean unexpectedBitrate;
    private String state;
    private Boolean healthy;
    static final ClientLogger LOGGER = new ClientLogger(MediaLiveEventIngestHeartbeatEventData.class);

    public String getTrackType() {
        return this.trackType;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public String getTranscriptionLanguage() {
        return this.transcriptionLanguage;
    }

    public String getTranscriptionState() {
        return this.transcriptionState;
    }

    public Long getBitrate() {
        return this.bitrate;
    }

    public Long getIncomingBitrate() {
        return this.incomingBitrate;
    }

    public Integer getIngestDriftValue() {
        if ("n/a".equals(this.ingestDriftValue)) {
            return null;
        }
        try {
            return Integer.parseInt(this.ingestDriftValue);
        }
        catch (NumberFormatException ex) {
            LOGGER.logExceptionAsError((RuntimeException)ex);
            return null;
        }
    }

    public OffsetDateTime getLastFragmentArrivalTime() {
        return OffsetDateTime.parse(this.lastFragmentArrivalTime);
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public String getTimescale() {
        return this.timescale;
    }

    public Long getOverlapCount() {
        return this.overlapCount;
    }

    public Long getDiscontinuityCount() {
        return this.discontinuityCount;
    }

    public Long getNonincreasingCount() {
        return this.nonincreasingCount;
    }

    public Boolean isUnexpectedBitrate() {
        return this.unexpectedBitrate;
    }

    public String getState() {
        return this.state;
    }

    public Boolean isHealthy() {
        return this.healthy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MediaLiveEventIngestHeartbeatEventData fromJson(JsonReader jsonReader) throws IOException {
        return (MediaLiveEventIngestHeartbeatEventData)jsonReader.readObject(reader -> {
            MediaLiveEventIngestHeartbeatEventData deserializedMediaLiveEventIngestHeartbeatEventData = new MediaLiveEventIngestHeartbeatEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("trackType".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.trackType = reader.getString();
                    continue;
                }
                if ("trackName".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.trackName = reader.getString();
                    continue;
                }
                if ("transcriptionLanguage".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.transcriptionLanguage = reader.getString();
                    continue;
                }
                if ("transcriptionState".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.transcriptionState = reader.getString();
                    continue;
                }
                if ("bitrate".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.bitrate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("incomingBitrate".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.incomingBitrate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("ingestDriftValue".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.ingestDriftValue = reader.getString();
                    continue;
                }
                if ("lastFragmentArrivalTime".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.lastFragmentArrivalTime = reader.getString();
                    continue;
                }
                if ("lastTimestamp".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.lastTimestamp = reader.getString();
                    continue;
                }
                if ("timescale".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.timescale = reader.getString();
                    continue;
                }
                if ("overlapCount".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.overlapCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("discontinuityCount".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.discontinuityCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("nonincreasingCount".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.nonincreasingCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("unexpectedBitrate".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.unexpectedBitrate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.state = reader.getString();
                    continue;
                }
                if ("healthy".equals(fieldName)) {
                    deserializedMediaLiveEventIngestHeartbeatEventData.healthy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaLiveEventIngestHeartbeatEventData;
        });
    }
}

