/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.PageViewData;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class PageViewTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_URL_LENGTH = 2048;
    private final PageViewData data;

    public static PageViewTelemetryBuilder create() {
        return new PageViewTelemetryBuilder(new PageViewData());
    }

    private PageViewTelemetryBuilder(PageViewData data) {
        super(data, "PageView", "PageViewData");
        this.data = data;
    }

    public void setId(String id) {
        this.data.setId(TelemetryTruncation.truncateTelemetry(id, 512, "PageView.id"));
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 1024, "PageView.name"));
    }

    public void setUrl(String url) {
        this.data.setUrl(TelemetryTruncation.truncateTelemetry(url, 2048, "PageView.url"));
    }

    public void setDuration(String duration) {
        this.data.setDuration(duration);
    }

    public void setReferredUri(String referredUri) {
        this.data.setReferredUri(TelemetryTruncation.truncateTelemetry(referredUri, 2048, "PageView.referredUri"));
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

