/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.RemoteDependencyData;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class RemoteDependencyTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_DATA_LENGTH = 8192;
    private static final int MAX_RESULT_CODE_LENGTH = 1024;
    private static final int MAX_DEPENDENCY_TYPE_LENGTH = 1024;
    private static final int MAX_TARGET_NAME_LENGTH = 1024;
    private final RemoteDependencyData data;

    public static RemoteDependencyTelemetryBuilder create() {
        return new RemoteDependencyTelemetryBuilder(new RemoteDependencyData());
    }

    private RemoteDependencyTelemetryBuilder(RemoteDependencyData data) {
        super(data, "RemoteDependency", "RemoteDependencyData");
        this.data = data;
    }

    public void setId(String id) {
        this.data.setId(TelemetryTruncation.truncateTelemetry(id, 512, "RemoteDependency.id"));
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 1024, "RemoteDependency.name"));
    }

    public void setResultCode(String resultCode) {
        this.data.setResultCode(TelemetryTruncation.truncateTelemetry(resultCode, 1024, "RemoteDependency.resultCode"));
    }

    public void setData(String data) {
        this.data.setData(TelemetryTruncation.truncateTelemetry(data, 8192, "RemoteDependency.data"));
    }

    public void setType(String type) {
        this.data.setType(TelemetryTruncation.truncateTelemetry(type, 1024, "RemoteDependency.type"));
    }

    public void setTarget(String target) {
        this.data.setTarget(TelemetryTruncation.truncateTelemetry(target, 1024, "RemoteDependency.target"));
    }

    public void setDuration(String duration) {
        this.data.setDuration(duration);
    }

    public void setSuccess(Boolean success) {
        this.data.setSuccess(success);
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

