/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.builders;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.AbstractTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.builders.TelemetryTruncation;
import com.azure.monitor.opentelemetry.exporter.implementation.models.RequestData;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public final class RequestTelemetryBuilder
extends AbstractTelemetryBuilder {
    private static final int MAX_SOURCE_LENGTH = 1024;
    private static final int MAX_RESPONSE_CODE_LENGTH = 1024;
    private static final int MAX_URL_LENGTH = 2048;
    private final RequestData data;

    public static RequestTelemetryBuilder create() {
        return new RequestTelemetryBuilder(new RequestData());
    }

    private RequestTelemetryBuilder(RequestData data) {
        super(data, "Request", "RequestData");
        this.data = data;
    }

    public void setId(String id) {
        this.data.setId(TelemetryTruncation.truncateTelemetry(id, 512, "Request.id"));
    }

    public void setName(String name) {
        this.data.setName(TelemetryTruncation.truncateTelemetry(name, 1024, "Request.name"));
    }

    public void setDuration(String duration) {
        this.data.setDuration(duration);
    }

    public void setSuccess(boolean success) {
        this.data.setSuccess(success);
    }

    public void setResponseCode(String responseCode) {
        this.data.setResponseCode(TelemetryTruncation.truncateTelemetry(responseCode, 1024, "Request.responseCode"));
    }

    public void setSource(String source) {
        this.data.setSource(TelemetryTruncation.truncateTelemetry(source, 1024, "Request.source"));
    }

    public void setUrl(String url) {
        this.data.setUrl(TelemetryTruncation.truncateTelemetry(url, 2048, "Request.url"));
    }

    public void addMeasurement(@Nullable String key, Double value) {
        if (key == null || key.isEmpty() || key.length() > 150) {
            return;
        }
        Map<String, Double> measurements = this.data.getMeasurements();
        if (measurements == null) {
            measurements = new HashMap<String, Double>();
            this.data.setMeasurements(measurements);
        }
        measurements.put(key, value);
    }

    @Override
    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.data.getProperties();
        if (properties == null) {
            properties = new HashMap<String, String>();
            this.data.setProperties(properties);
        }
        return properties;
    }
}

