/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.localstorage;

import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.FileUtil;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalFileCache;
import com.azure.monitor.opentelemetry.exporter.implementation.logging.OperationLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.ThreadPoolUtils;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class LocalFilePurger
implements Runnable {
    private final File folder;
    private final long expiredIntervalSeconds;
    private final OperationLogger operationLogger;
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadPoolUtils.createDaemonThreadFactory(LocalFilePurger.class));

    LocalFilePurger(File folder, boolean suppressWarnings) {
        this(folder, TimeUnit.DAYS.toSeconds(2L), TimeUnit.DAYS.toSeconds(1L), suppressWarnings);
    }

    LocalFilePurger(File folder, long expiredIntervalSeconds, long purgeIntervalSeconds, boolean suppressWarnings) {
        this.folder = folder;
        this.expiredIntervalSeconds = expiredIntervalSeconds;
        this.operationLogger = suppressWarnings ? OperationLogger.NOOP : new OperationLogger(LocalFilePurger.class, "Purging expired telemetry from disk");
        this.scheduledExecutor.scheduleWithFixedDelay(this, Math.min(purgeIntervalSeconds, 60L), purgeIntervalSeconds, TimeUnit.SECONDS);
    }

    void shutdown() {
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void run() {
        this.purgedExpiredFiles(this.folder);
    }

    private void purgedExpiredFiles(File folder) {
        for (File file : FileUtil.listTrnFiles(folder)) {
            if (!LocalFileCache.isExpired(file, this.expiredIntervalSeconds)) continue;
            if (!FileUtil.deleteFileWithRetries(file)) {
                this.operationLogger.recordFailure("Unable to delete file: " + file.getAbsolutePath(), AzureMonitorMsgId.DISK_PERSISTENCE_PURGE_ERROR);
                continue;
            }
            this.operationLogger.recordSuccess();
        }
    }
}

