/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.pipeline;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class TelemetryPipelineResponse {
    private static final String INVALID_INSTRUMENTATION_KEY = "Invalid instrumentation key";
    private final int statusCode;
    private final String body;

    TelemetryPipelineResponse(int statusCode, String body) {
        this.statusCode = statusCode;
        this.body = body;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public Set<String> getErrors() {
        return TelemetryPipelineResponse.parseErrors(this.body);
    }

    public boolean isInvalidInstrumentationKey() {
        Set<String> errors = TelemetryPipelineResponse.parseErrors(this.body);
        return errors != null && errors.contains(INVALID_INSTRUMENTATION_KEY);
    }

    private static Set<String> parseErrors(String body) {
        JsonNode jsonNode;
        try {
            jsonNode = new ObjectMapper().readTree(body);
        }
        catch (JsonProcessingException e) {
            return Collections.singleton("Could not parse response");
        }
        ArrayList errorNodes = new ArrayList();
        jsonNode.get("errors").forEach(errorNodes::add);
        return errorNodes.stream().map(errorNode -> errorNode.get("message").asText()).filter(s -> !s.equals("Telemetry sampled out.")).collect(Collectors.toSet());
    }
}

