/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.statsbeat;

import com.azure.monitor.opentelemetry.exporter.implementation.builders.StatsbeatTelemetryBuilder;
import com.azure.monitor.opentelemetry.exporter.implementation.localstorage.LocalStorageStats;
import com.azure.monitor.opentelemetry.exporter.implementation.pipeline.TelemetryItemExporter;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.BaseStatsbeat;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.CustomDimensions;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;

public class NonessentialStatsbeat
extends BaseStatsbeat
implements LocalStorageStats {
    private static final String READ_FAILURE_COUNT = "Read_Failure_Count";
    private static final String WRITE_FAILURE_COUNT = "Write_Failure_Count";
    private final AtomicLong readFailureCount = new AtomicLong();
    private final AtomicLong writeFailureCount = new AtomicLong();

    NonessentialStatsbeat() {
        super(new CustomDimensions());
    }

    NonessentialStatsbeat(CustomDimensions customDimensions) {
        super(customDimensions);
    }

    @Override
    protected void send(TelemetryItemExporter telemetryItemExporter) {
        long writeFailures;
        long readFailures = this.readFailureCount.getAndSet(0L);
        if (readFailures != 0L) {
            StatsbeatTelemetryBuilder telemetryItem = this.createStatsbeatTelemetry(READ_FAILURE_COUNT, this.readFailureCount.get());
            telemetryItemExporter.send(Collections.singletonList(telemetryItem.build()));
        }
        if ((writeFailures = this.readFailureCount.getAndSet(0L)) != 0L) {
            StatsbeatTelemetryBuilder telemetryItem = this.createStatsbeatTelemetry(WRITE_FAILURE_COUNT, this.writeFailureCount.get());
            telemetryItemExporter.send(Collections.singletonList(telemetryItem.build()));
        }
    }

    @Override
    public void incrementReadFailureCount() {
        this.readFailureCount.incrementAndGet();
    }

    long getReadFailureCount() {
        return this.readFailureCount.get();
    }

    @Override
    public void incrementWriteFailureCount() {
        this.writeFailureCount.incrementAndGet();
    }

    public long getWriteFailureCount() {
        return this.writeFailureCount.get();
    }
}

