/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.core.util.logging.ClientLogger;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.AzureMonitorMsgId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.MDC;
import reactor.util.annotation.Nullable;

public class HostName {
    private static final ClientLogger logger = new ClientLogger(HostName.class);

    @Nullable
    public static String get() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            try (MDC.MDCCloseable ignored = AzureMonitorMsgId.HOSTNAME_ERROR.makeActive();){
                logger.warning("Error resolving hostname", new Object[]{ex});
            }
            return null;
        }
    }

    private HostName() {
    }
}

