/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.MetadataInstanceResponse;
import com.azure.monitor.opentelemetry.exporter.implementation.statsbeat.RpAttachType;
import com.azure.monitor.opentelemetry.exporter.implementation.utils.SystemInformation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyHelper {
    private static final Logger logger = LoggerFactory.getLogger(PropertyHelper.class);
    public static final String SDK_VERSION_FILE_NAME = "ai.sdk-version.properties";
    public static final String VERSION_STRING_PREFIX = "java:";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final String UNKNOWN_VERSION_VALUE = "unknown";
    private static volatile char rpIntegrationChar;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(String name) throws IOException {
        InputStream inputStream;
        Properties props = new Properties();
        ClassLoader classLoader = PropertyHelper.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((inputStream = classLoader.getResourceAsStream(name)) != null) {
            try {
                props.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return props;
    }

    private static Properties getSdkVersionProperties() {
        try {
            return PropertyHelper.getProperties(SDK_VERSION_FILE_NAME);
        }
        catch (IOException e) {
            logger.error("Could not find sdk version file '{}'", (Object)SDK_VERSION_FILE_NAME, (Object)e);
            return new Properties();
        }
    }

    public static String getQualifiedSdkVersionString() {
        return SdkPropertyValues.sdkVersionString;
    }

    public static void setSdkNamePrefix(String sdkNamePrefix) {
        SdkPropertyValues.sdkVersionString = sdkNamePrefix + VERSION_STRING_PREFIX + SdkPropertyValues.SDK_VERSION_NUMBER;
    }

    public static String getSdkVersionNumber() {
        return SdkPropertyValues.SDK_VERSION_NUMBER;
    }

    public static boolean isRpIntegration() {
        return rpIntegrationChar != '\u0000';
    }

    public static void setRpIntegrationChar(char ch) {
        rpIntegrationChar = ch;
    }

    public static void lazyUpdateVmRpIntegration(MetadataInstanceResponse response) {
        rpIntegrationChar = (char)118;
        PropertyHelper.setSdkNamePrefix(PropertyHelper.getRpIntegrationSdkNamePrefix());
        RpAttachType.setRpAttachType(RpAttachType.STANDALONE_AUTO);
    }

    public static String getRpIntegrationSdkNamePrefix() {
        StringBuilder sdkNamePrefix = new StringBuilder(3);
        sdkNamePrefix.append(rpIntegrationChar);
        if (SystemInformation.isWindows()) {
            sdkNamePrefix.append("w");
        } else if (SystemInformation.isLinux()) {
            sdkNamePrefix.append("l");
        } else {
            logger.warn("could not detect os: {}", (Object)System.getProperty("os.name"));
            sdkNamePrefix.append("u");
        }
        sdkNamePrefix.append("_");
        return sdkNamePrefix.toString();
    }

    private PropertyHelper() {
    }

    private static class SdkPropertyValues {
        private static final String SDK_VERSION_NUMBER;
        private static volatile String sdkVersionString;

        private SdkPropertyValues() {
        }

        static {
            Properties properties = PropertyHelper.getSdkVersionProperties();
            SDK_VERSION_NUMBER = properties.getProperty(PropertyHelper.VERSION_PROPERTY_NAME, PropertyHelper.UNKNOWN_VERSION_VALUE);
            sdkVersionString = PropertyHelper.VERSION_STRING_PREFIX + SDK_VERSION_NUMBER;
        }
    }
}

