/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.opentelemetry.exporter.implementation.utils;

public enum StatusCode {
    TEMPORARY_REDIRECT(307),
    PERMANENTY_REDIRECT(308),
    UNAUTHORIZED(401),
    FORBIDDEN(403),
    REQUEST_TIMEOUT(408),
    TOO_MANY_REQUESTS(429),
    INTERNAL_SERVER_ERROR(500),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504);

    private final int code;

    private StatusCode(int code) {
        this.code = code;
    }

    public static boolean isRetryable(int statusCode) {
        return statusCode == StatusCode.UNAUTHORIZED.code || statusCode == StatusCode.FORBIDDEN.code || statusCode == StatusCode.REQUEST_TIMEOUT.code || statusCode == StatusCode.TOO_MANY_REQUESTS.code || statusCode == StatusCode.INTERNAL_SERVER_ERROR.code || statusCode == StatusCode.BAD_GATEWAY.code || statusCode == StatusCode.SERVICE_UNAVAILABLE.code || statusCode == StatusCode.GATEWAY_TIMEOUT.code;
    }

    public static boolean isRedirect(int statusCode) {
        return statusCode == 307 || statusCode == 308;
    }
}

