/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.implementation.models.SuggestResult;
import java.io.IOException;
import java.util.List;

public final class SuggestDocumentsResult
implements JsonSerializable<SuggestDocumentsResult> {
    private final List<SuggestResult> results;
    private Double coverage;

    public SuggestDocumentsResult(List<SuggestResult> results) {
        this.results = results;
    }

    public List<SuggestResult> getResults() {
        return this.results;
    }

    public Double getCoverage() {
        return this.coverage;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SuggestDocumentsResult fromJson(JsonReader jsonReader) throws IOException {
        return (SuggestDocumentsResult)jsonReader.readObject(reader -> {
            boolean resultsFound = false;
            List results = null;
            Double coverage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    results = reader.readArray(reader1 -> SuggestResult.fromJson(reader1));
                    resultsFound = true;
                    continue;
                }
                if ("@search.coverage".equals(fieldName)) {
                    coverage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            if (resultsFound) {
                SuggestDocumentsResult deserializedSuggestDocumentsResult = new SuggestDocumentsResult(results);
                deserializedSuggestDocumentsResult.coverage = coverage;
                return deserializedSuggestDocumentsResult;
            }
            throw new IllegalStateException("Missing required property: value");
        });
    }
}

