/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.logging.ClientLogger;
import com.azure.search.documents.implementation.util.Utility;
import java.util.List;
import java.util.Objects;

public final class SpatialFormatter {
    private static final int LONGITUDE_LATITUDE_MAX_LENGTH = 35;
    private static final int POINT_EXPRESSION_IDENTIFIER_LENGTH = "geography'POINT()".length();
    private static final int POLYGON_EXPRESSION_IDENTIFIER_LENGTH = "geography'POLYGON(())".length();

    public static String encodePoint(double longitude, double latitude) {
        StringBuilder builder = new StringBuilder(POINT_EXPRESSION_IDENTIFIER_LENGTH + 35);
        return SpatialFormatter.addPoint(builder.append("geography'POINT("), longitude, latitude).append(")'").toString();
    }

    public static String encodePolygon(GeoLineString line, ClientLogger logger) {
        Objects.requireNonNull(line, "'line' cannot be null.");
        List coordinates = line.getCoordinates();
        if (coordinates.size() < 4) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'line' must have at least four coordinates to form a searchable polygon."));
        }
        if (!Objects.equals(coordinates.get(0), coordinates.get(coordinates.size() - 1))) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'line' must have matching first and last coordinates to form a searchable polygon."));
        }
        return SpatialFormatter.encodePolygon(coordinates);
    }

    public static String encodePolygon(GeoPolygon polygon, ClientLogger logger) {
        Objects.requireNonNull(polygon, "'polygon' cannot be null.");
        if (polygon.getRings().size() != 1) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'polygon' must have exactly one ring to form a searchable polygon."));
        }
        return SpatialFormatter.encodePolygon(polygon.getOuterRing().getCoordinates());
    }

    private static String encodePolygon(List<GeoPosition> ring) {
        int approximateODataExpressionSize = POLYGON_EXPRESSION_IDENTIFIER_LENGTH + ring.size() * 35 + ring.size();
        StringBuilder builder = new StringBuilder(approximateODataExpressionSize).append("geography'POLYGON((");
        boolean first = true;
        for (GeoPosition position : ring) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            SpatialFormatter.addPoint(builder, position.getLongitude(), position.getLatitude());
        }
        return builder.append("))'").toString();
    }

    private static StringBuilder addPoint(StringBuilder builder, double longitude, double latitude) {
        return builder.append(Utility.formatCoordinate(longitude)).append(' ').append(Utility.formatCoordinate(latitude));
    }
}

