/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ErrorResponseException;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.models.SynonymMap;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SynonymMapsImpl {
    private final SynonymMapsService service;
    private final SearchServiceClientImpl client;

    SynonymMapsImpl(SearchServiceClientImpl client) {
        this.service = (SynonymMapsService)RestProxy.create(SynonymMapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createOrUpdateWithResponseAsync(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createOrUpdateWithResponseAsync(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createOrUpdateAsync(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.createOrUpdateWithResponseAsync(synonymMapName, synonymMap, ifMatch, ifNoneMatch, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createOrUpdateAsync(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.createOrUpdateWithResponseAsync(synonymMapName, synonymMap, ifMatch, ifNoneMatch, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createOrUpdateWithResponse(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdateSync(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap createOrUpdate(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return (SynonymMap)this.createOrUpdateWithResponse(synonymMapName, synonymMap, ifMatch, ifNoneMatch, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        return this.deleteWithResponseAsync(synonymMapName, ifMatch, ifNoneMatch, requestOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        return this.deleteWithResponseAsync(synonymMapName, ifMatch, ifNoneMatch, requestOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.deleteSync(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions) {
        this.deleteWithResponse(synonymMapName, ifMatch, ifNoneMatch, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> getWithResponseAsync(String synonymMapName, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> getWithResponseAsync(String synonymMapName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> getAsync(String synonymMapName, RequestOptions requestOptions) {
        return this.getWithResponseAsync(synonymMapName, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> getAsync(String synonymMapName, RequestOptions requestOptions, Context context) {
        return this.getWithResponseAsync(synonymMapName, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> getWithResponse(String synonymMapName, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.getSync(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap get(String synonymMapName, RequestOptions requestOptions) {
        return (SynonymMap)this.getWithResponse(synonymMapName, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListSynonymMapsResult>> listWithResponseAsync(String select, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListSynonymMapsResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListSynonymMapsResult> listAsync(String select, RequestOptions requestOptions) {
        return this.listWithResponseAsync(select, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((ListSynonymMapsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListSynonymMapsResult> listAsync(String select, RequestOptions requestOptions, Context context) {
        return this.listWithResponseAsync(select, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((ListSynonymMapsResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListSynonymMapsResult> listWithResponse(String select, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.listSync(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListSynonymMapsResult list(String select, RequestOptions requestOptions) {
        return (ListSynonymMapsResult)this.listWithResponse(select, requestOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createWithResponseAsync(SynonymMap synonymMap, RequestOptions requestOptions) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SynonymMap>> createWithResponseAsync(SynonymMap synonymMap, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createAsync(SynonymMap synonymMap, RequestOptions requestOptions) {
        return this.createWithResponseAsync(synonymMap, requestOptions).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SynonymMap> createAsync(SynonymMap synonymMap, RequestOptions requestOptions, Context context) {
        return this.createWithResponseAsync(synonymMap, requestOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((SynonymMap)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SynonymMap> createWithResponse(SynonymMap synonymMap, RequestOptions requestOptions, Context context) {
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createSync(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SynonymMap create(SynonymMap synonymMap, RequestOptions requestOptions) {
        return (SynonymMap)this.createWithResponse(synonymMap, requestOptions, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientS")
    public static interface SynonymMapsService {
        @Put(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SynonymMap>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SynonymMap var9, Context var10);

        @Put(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SynonymMap> createOrUpdateSync(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") SynonymMap var9, Context var10);

        @Delete(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<Void> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SynonymMap>> get(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SynonymMap> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/synonymmaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<ListSynonymMapsResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/synonymmaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<ListSynonymMapsResult> listSync(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/synonymmaps")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<SynonymMap>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SynonymMap var5, Context var6);

        @Post(value="/synonymmaps")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Response<SynonymMap> createSync(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, @BodyParam(value="application/json") SynonymMap var5, Context var6);
    }
}

