/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionInterpolation;
import com.azure.search.documents.indexes.models.TagScoringParameters;
import java.io.IOException;
import java.util.ArrayList;

public final class TagScoringFunction
extends ScoringFunction {
    private String type = "tag";
    private final TagScoringParameters parameters;

    public TagScoringFunction(String fieldName, double boost, TagScoringParameters parameters) {
        super(fieldName, boost);
        this.parameters = parameters;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public TagScoringParameters getParameters() {
        return this.parameters;
    }

    @Override
    public TagScoringFunction setInterpolation(ScoringFunctionInterpolation interpolation) {
        super.setInterpolation(interpolation);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fieldName", this.getFieldName());
        jsonWriter.writeDoubleField("boost", this.getBoost());
        jsonWriter.writeStringField("interpolation", this.getInterpolation() == null ? null : this.getInterpolation().toString());
        jsonWriter.writeJsonField("tag", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static TagScoringFunction fromJson(JsonReader jsonReader) throws IOException {
        return (TagScoringFunction)jsonReader.readObject(reader -> {
            boolean fieldNameFound = false;
            String fieldName = null;
            boolean boostFound = false;
            double boost = 0.0;
            ScoringFunctionInterpolation interpolation = null;
            boolean parametersFound = false;
            TagScoringParameters parameters = null;
            String type = "tag";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String jsonFieldName = reader.getFieldName();
                reader.nextToken();
                if ("fieldName".equals(jsonFieldName)) {
                    fieldName = reader.getString();
                    fieldNameFound = true;
                    continue;
                }
                if ("boost".equals(jsonFieldName)) {
                    boost = reader.getDouble();
                    boostFound = true;
                    continue;
                }
                if ("interpolation".equals(jsonFieldName)) {
                    interpolation = ScoringFunctionInterpolation.fromString(reader.getString());
                    continue;
                }
                if ("tag".equals(jsonFieldName)) {
                    parameters = TagScoringParameters.fromJson(reader);
                    parametersFound = true;
                    continue;
                }
                if ("type".equals(jsonFieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            if (fieldNameFound && boostFound && parametersFound) {
                TagScoringFunction deserializedTagScoringFunction = new TagScoringFunction(fieldName, boost, parameters);
                deserializedTagScoringFunction.setInterpolation(interpolation);
                deserializedTagScoringFunction.type = type;
                return deserializedTagScoringFunction;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!fieldNameFound) {
                missingProperties.add("fieldName");
            }
            if (!boostFound) {
                missingProperties.add("boost");
            }
            if (!parametersFound) {
                missingProperties.add("tag");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

