/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.TracingOptions;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.security.keyvault.administration.KeyVaultAdministrationServiceVersion;
import com.azure.security.keyvault.administration.KeyVaultBackupAsyncClient;
import com.azure.security.keyvault.administration.KeyVaultBackupClient;
import com.azure.security.keyvault.administration.implementation.KeyVaultCredentialPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={KeyVaultBackupClient.class, KeyVaultBackupAsyncClient.class})
public final class KeyVaultBackupClientBuilder
implements TokenCredentialTrait<KeyVaultBackupClientBuilder>,
HttpTrait<KeyVaultBackupClientBuilder>,
ConfigurationTrait<KeyVaultBackupClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultBackupClientBuilder.class);
    private static final String AZURE_KEY_VAULT_RBAC = "azure-key-vault-administration.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private URL vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private ClientOptions clientOptions;
    private KeyVaultAdministrationServiceVersion serviceVersion;
    private boolean disableChallengeResourceVerification = false;

    public KeyVaultBackupClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties((String)AZURE_KEY_VAULT_RBAC);
    }

    public KeyVaultBackupClient buildClient() {
        Configuration buildConfiguration = this.validateEndpointAndGetBuildConfiguration();
        this.serviceVersion = this.getServiceVersion();
        if (this.pipeline != null) {
            return new KeyVaultBackupClient(this.vaultUrl, this.pipeline, this.serviceVersion);
        }
        HttpPipeline buildPipeline = this.getPipeline(buildConfiguration);
        return new KeyVaultBackupClient(this.vaultUrl, buildPipeline, this.serviceVersion);
    }

    public KeyVaultBackupAsyncClient buildAsyncClient() {
        Configuration buildConfiguration = this.validateEndpointAndGetBuildConfiguration();
        this.serviceVersion = this.getServiceVersion();
        if (this.pipeline != null) {
            return new KeyVaultBackupAsyncClient(this.vaultUrl, this.pipeline, this.serviceVersion);
        }
        HttpPipeline buildPipeline = this.getPipeline(buildConfiguration);
        return new KeyVaultBackupAsyncClient(this.vaultUrl, buildPipeline, this.serviceVersion);
    }

    private Configuration validateEndpointAndGetBuildConfiguration() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        URL buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Azure Key Vault endpoint url is required."));
        }
        return buildConfiguration;
    }

    private KeyVaultAdministrationServiceVersion getServiceVersion() {
        return this.serviceVersion != null ? this.serviceVersion : KeyVaultAdministrationServiceVersion.getLatest();
    }

    private HttpPipeline getPipeline(Configuration buildConfiguration) {
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions != null ? this.clientOptions : DEFAULT_CLIENT_OPTIONS;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)this.httpLogOptions), clientName, clientVersion, buildConfiguration));
        ArrayList httpHeaderList = new ArrayList();
        localClientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        policies.add((Object)new KeyVaultCredentialPolicy(this.credential, this.disableChallengeResourceVerification));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = localClientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(clientName, clientVersion, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).tracer(tracer).build();
    }

    public KeyVaultBackupClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            this.vaultUrl = new URL(vaultUrl);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("The Azure Key Vault URL is malformed.", e));
        }
        return this;
    }

    public KeyVaultBackupClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public KeyVaultBackupClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public KeyVaultBackupClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public KeyVaultBackupClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    public KeyVaultBackupClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public KeyVaultBackupClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public KeyVaultBackupClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public KeyVaultBackupClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public KeyVaultBackupClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public KeyVaultBackupClientBuilder serviceVersion(KeyVaultAdministrationServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public KeyVaultBackupClientBuilder disableChallengeResourceVerification() {
        this.disableChallengeResourceVerification = true;
        return this;
    }

    private URL getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty((CharSequence)configEndpoint)) {
            return null;
        }
        try {
            return new URL(configEndpoint);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

