/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.administration.implementation;

import com.azure.security.keyvault.administration.implementation.models.Error;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultError;
import com.azure.security.keyvault.administration.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationError;
import com.azure.security.keyvault.administration.models.KeyVaultAdministrationException;

public final class KeyVaultAdministrationUtils {
    private KeyVaultAdministrationUtils() {
        throw new UnsupportedOperationException("Cannot instantiate KeyVaultAdministrationUtils");
    }

    public static KeyVaultAdministrationException toKeyVaultAdministrationException(KeyVaultErrorException exception) {
        if (exception == null) {
            return null;
        }
        return new KeyVaultAdministrationException(exception.getMessage(), exception.getResponse(), KeyVaultAdministrationUtils.toKeyVaultError(exception.getValue()));
    }

    public static KeyVaultAdministrationError toKeyVaultError(KeyVaultError keyVaultError) {
        if (keyVaultError == null) {
            return null;
        }
        return KeyVaultAdministrationUtils.createKeyVaultErrorFromError(keyVaultError.getError());
    }

    public static KeyVaultAdministrationError createKeyVaultErrorFromError(Error error) {
        if (error == null) {
            return null;
        }
        return new KeyVaultAdministrationError(error.getCode(), error.getMessage(), KeyVaultAdministrationUtils.createKeyVaultErrorFromError(error.getInnerError()));
    }

    public static Throwable mapThrowableToKeyVaultAdministrationException(Throwable throwable) {
        if (throwable instanceof KeyVaultErrorException) {
            return KeyVaultAdministrationUtils.toKeyVaultAdministrationException((KeyVaultErrorException)((Object)throwable));
        }
        return throwable;
    }
}

