/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.security.keyvault.certificates.implementation.IdMetadata;
import java.net.MalformedURLException;
import java.net.URL;

public final class CertificatesUtils {
    public static IdMetadata getIdMetadata(String id, int vaultUrlIndex, int nameIndex, int versionIndex, ClientLogger logger) {
        if (CoreUtils.isNullOrEmpty((CharSequence)id)) {
            return new IdMetadata(id, null, null, null);
        }
        try {
            URL url = new URL(id);
            String[] tokens = url.getPath().split("/");
            return new IdMetadata(id, CertificatesUtils.getIdMetadataPiece(tokens, vaultUrlIndex), CertificatesUtils.getIdMetadataPiece(tokens, nameIndex), CertificatesUtils.getIdMetadataPiece(tokens, versionIndex));
        }
        catch (MalformedURLException e) {
            logger.error("Received Malformed Secret Id URL from KV Service");
            return new IdMetadata(id, null, null, null);
        }
    }

    private static String getIdMetadataPiece(String[] pieces, int index) {
        if (index == -1) {
            return null;
        }
        return pieces.length >= index + 1 ? pieces[index] : null;
    }

    private CertificatesUtils() {
    }
}

