/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.certificates.implementation.models;

import com.azure.core.util.Base64Url;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.security.keyvault.certificates.implementation.models.CertificateAttributes;
import com.azure.security.keyvault.certificates.implementation.models.CertificateBundle;
import com.azure.security.keyvault.certificates.implementation.models.CertificatePolicy;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedCertificateBundle
extends CertificateBundle {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedCertificateBundle setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public DeletedCertificateBundle setCer(byte[] cer) {
        super.setCer(cer);
        return this;
    }

    @Override
    public DeletedCertificateBundle setContentType(String contentType) {
        super.setContentType(contentType);
        return this;
    }

    @Override
    public DeletedCertificateBundle setAttributes(CertificateAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedCertificateBundle setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBinaryField("cer", this.getCer());
        jsonWriter.writeStringField("contentType", this.getContentType());
        jsonWriter.writeJsonField("attributes", (JsonSerializable)this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedCertificateBundle fromJson(JsonReader jsonReader) throws IOException {
        return (DeletedCertificateBundle)jsonReader.readObject(reader -> {
            DeletedCertificateBundle deserializedDeletedCertificateBundle = new DeletedCertificateBundle();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setId(reader.getString());
                    continue;
                }
                if ("kid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setKid(reader.getString());
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setSid(reader.getString());
                    continue;
                }
                if ("x5t".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setX509Thumbprint((Base64Url)reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString())));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setPolicy(CertificatePolicy.fromJson(reader));
                    continue;
                }
                if ("cer".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setCer(reader.getBinary());
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setContentType(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.setAttributes(CertificateAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedCertificateBundle.setTags(tags);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.scheduledPurgeDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedCertificateBundle.deletedDate = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedCertificateBundle;
        });
    }
}

