/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share.models;

import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.share.models.FileLastWrittenMode;
import com.azure.storage.file.share.models.ShareRequestConditions;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class ShareFileUploadRangeOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final long length;
    private Long offset;
    private ShareRequestConditions requestConditions;
    private FileLastWrittenMode lastWrittenMode;

    public ShareFileUploadRangeOptions(Flux<ByteBuffer> dataFlux, long length) {
        StorageImplUtils.assertNotNull((String)"dataFlux", dataFlux);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)0L, (long)Long.MAX_VALUE);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = length;
    }

    public ShareFileUploadRangeOptions(InputStream dataStream, long length) {
        StorageImplUtils.assertNotNull((String)"dataStream", (Object)length);
        StorageImplUtils.assertInBounds((String)"length", (long)length, (long)1L, (long)Long.MAX_VALUE);
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public long getLength() {
        return this.length;
    }

    public Long getOffset() {
        return this.offset;
    }

    public ShareFileUploadRangeOptions setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public ShareRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ShareFileUploadRangeOptions setRequestConditions(ShareRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public FileLastWrittenMode getLastWrittenMode() {
        return this.lastWrittenMode;
    }

    public ShareFileUploadRangeOptions setLastWrittenMode(FileLastWrittenMode lastWrittenMode) {
        this.lastWrittenMode = lastWrittenMode;
        return this;
    }
}

