/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigurationServiceResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.implementation.Utils;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitProperty;
import com.azure.resourcemanager.appplatform.models.ConfigurationServiceGitRepository;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringConfigurationService;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class SpringConfigurationServiceImpl
extends ExternalChildResourceImpl<SpringConfigurationService, ConfigurationServiceResourceInner, SpringServiceImpl, SpringService>
implements SpringConfigurationService {
    protected SpringConfigurationServiceImpl(String name, SpringServiceImpl parent, ConfigurationServiceResourceInner innerObject) {
        super(name, (Object)parent, (Object)innerObject);
    }

    @Override
    public Double cpu() {
        return Utils.fromCpuString(((ConfigurationServiceResourceInner)((Object)this.innerModel())).properties().resourceRequests().cpu());
    }

    @Override
    public Double memory() {
        return Utils.fromMemoryString(((ConfigurationServiceResourceInner)((Object)this.innerModel())).properties().resourceRequests().memory());
    }

    @Override
    public String gitUri() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::uri).orElse(null);
    }

    @Override
    public List<String> filePatterns() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::patterns).orElse(Collections.emptyList());
    }

    @Override
    public String branch() {
        return this.findDefaultRepository().map(ConfigurationServiceGitRepository::label).orElse(null);
    }

    @Override
    public ConfigurationServiceGitRepository getGitRepository(String name) {
        return this.findRepository(name).orElse(null);
    }

    private Optional<ConfigurationServiceGitRepository> findDefaultRepository() {
        return this.findRepository("default");
    }

    @Override
    public List<SpringApp> getAppBindings() {
        return ((SpringServiceImpl)this.parent()).apps().list().stream().filter(SpringApp::hasConfigurationServiceBinding).collect(Collectors.toList());
    }

    private Optional<ConfigurationServiceGitRepository> findRepository(String name) {
        if (name == null || ((ConfigurationServiceResourceInner)((Object)this.innerModel())).properties() == null || ((ConfigurationServiceResourceInner)((Object)this.innerModel())).properties().settings() == null) {
            return Optional.empty();
        }
        ConfigurationServiceGitProperty property = ((ConfigurationServiceResourceInner)((Object)this.innerModel())).properties().settings().gitProperty();
        if (property != null && property.repositories() != null) {
            return property.repositories().stream().filter(repository -> name.equals(repository.name())).findFirst();
        }
        return Optional.empty();
    }

    public String id() {
        return ((ConfigurationServiceResourceInner)((Object)this.innerModel())).id();
    }

    public Mono<SpringConfigurationService> createResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().createOrUpdateAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name(), (ConfigurationServiceResourceInner)((Object)this.innerModel())).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    public Mono<SpringConfigurationService> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().deleteAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    protected Mono<ConfigurationServiceResourceInner> getInnerAsync() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getConfigurationServices().getAsync(((SpringServiceImpl)this.parent()).resourceGroupName(), ((SpringServiceImpl)this.parent()).name(), this.name());
    }

    public AppPlatformManager manager() {
        return (AppPlatformManager)((SpringServiceImpl)this.parent()).manager();
    }
}

