/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.implementation.ServicePrincipalImpl;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.authorization.models.ServicePrincipals;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableWrappersImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import reactor.core.publisher.Mono;

public class ServicePrincipalsImpl
extends CreatableWrappersImpl<ServicePrincipal, ServicePrincipalImpl, MicrosoftGraphServicePrincipalInner>
implements ServicePrincipals,
HasManager<AuthorizationManager> {
    private final AuthorizationManager manager;

    public ServicePrincipalsImpl(AuthorizationManager authorizationManager) {
        this.manager = authorizationManager;
    }

    public PagedIterable<ServicePrincipal> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<ServicePrincipal> listAsync() {
        return PagedConverter.mapPage(this.inner().listServicePrincipalAsync(), this::wrapModel);
    }

    protected ServicePrincipalImpl wrapModel(MicrosoftGraphServicePrincipalInner servicePrincipalInner) {
        if (servicePrincipalInner == null) {
            return null;
        }
        return new ServicePrincipalImpl(servicePrincipalInner, this.manager());
    }

    public ServicePrincipalImpl getById(String id) {
        return (ServicePrincipalImpl)this.getByIdAsync(id).block();
    }

    public Mono<ServicePrincipal> getByIdAsync(String id) {
        return this.inner().getServicePrincipalAsync(id).map(this::wrapModel);
    }

    public ServicePrincipal getByName(String spn) {
        return (ServicePrincipal)this.getByNameAsync(spn).block();
    }

    public Mono<ServicePrincipal> getByNameAsync(String name) {
        return this.listByFilterAsync(String.format("displayName eq '%s'", name)).singleOrEmpty().switchIfEmpty(this.listByFilterAsync(String.format("servicePrincipalNames/any(c:c eq '%s')", name)).singleOrEmpty());
    }

    public ServicePrincipalImpl define(String name) {
        return new ServicePrincipalImpl(new MicrosoftGraphServicePrincipalInner().withDisplayName(name), this.manager());
    }

    protected ServicePrincipalImpl wrapModel(String name) {
        return new ServicePrincipalImpl(new MicrosoftGraphServicePrincipalInner().withDisplayName(name), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteServicePrincipalAsync(id);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public ServicePrincipalsServicePrincipalsClient inner() {
        return this.manager().serviceClient().getServicePrincipalsServicePrincipals();
    }

    public PagedIterable<ServicePrincipal> listByFilter(String filter) {
        return new PagedIterable(this.listByFilterAsync(filter));
    }

    public PagedFlux<ServicePrincipal> listByFilterAsync(String filter) {
        return PagedConverter.mapPage(this.inner().listServicePrincipalAsync(null, null, null, null, filter, null, null, null, null), this::wrapModel);
    }
}

