/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.IotHubResourcesClient;
import com.azure.resourcemanager.iothub.fluent.models.EndpointHealthDataInner;
import com.azure.resourcemanager.iothub.fluent.models.EventHubConsumerGroupInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubNameAvailabilityInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubQuotaMetricInfoInner;
import com.azure.resourcemanager.iothub.fluent.models.IotHubSkuDescriptionInner;
import com.azure.resourcemanager.iothub.fluent.models.JobResponseInner;
import com.azure.resourcemanager.iothub.fluent.models.RegistryStatisticsInner;
import com.azure.resourcemanager.iothub.fluent.models.SharedAccessSignatureAuthorizationRuleInner;
import com.azure.resourcemanager.iothub.fluent.models.TestAllRoutesResultInner;
import com.azure.resourcemanager.iothub.fluent.models.TestRouteResultInner;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.EndpointHealthDataListResult;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupBodyDescription;
import com.azure.resourcemanager.iothub.models.EventHubConsumerGroupsListResult;
import com.azure.resourcemanager.iothub.models.ExportDevicesRequest;
import com.azure.resourcemanager.iothub.models.ImportDevicesRequest;
import com.azure.resourcemanager.iothub.models.IotHubDescriptionListResult;
import com.azure.resourcemanager.iothub.models.IotHubQuotaMetricInfoListResult;
import com.azure.resourcemanager.iothub.models.IotHubSkuDescriptionListResult;
import com.azure.resourcemanager.iothub.models.JobResponseListResult;
import com.azure.resourcemanager.iothub.models.OperationInputs;
import com.azure.resourcemanager.iothub.models.SharedAccessSignatureAuthorizationRuleListResult;
import com.azure.resourcemanager.iothub.models.TagsResource;
import com.azure.resourcemanager.iothub.models.TestAllRoutesInput;
import com.azure.resourcemanager.iothub.models.TestRouteInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class IotHubResourcesClientImpl
implements IotHubResourcesClient {
    private final IotHubResourcesService service;
    private final IotHubClientImpl client;

    IotHubResourcesClientImpl(IotHubClientImpl client) {
        this.service = (IotHubResourcesService)RestProxy.create(IotHubResourcesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IotHubDescriptionInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IotHubDescriptionInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((IotHubDescriptionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IotHubDescriptionInner> getByResourceGroupWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (IotHubDescriptionInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, resourceName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (iotHubDescription == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubDescription is required and cannot be null."));
        }
        iotHubDescription.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, ifMatch, iotHubDescription, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (iotHubDescription == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubDescription is required and cannot be null."));
        }
        iotHubDescription.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, ifMatch, iotHubDescription, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription) {
        String ifMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginCreateOrUpdate(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> createOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> createOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription) {
        String ifMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> createOrUpdateAsync(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner createOrUpdate(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription) {
        String ifMatch = null;
        return (IotHubDescriptionInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner createOrUpdate(String resourceGroupName, String resourceName, IotHubDescriptionInner iotHubDescription, String ifMatch, Context context) {
        return (IotHubDescriptionInner)((Object)this.createOrUpdateAsync(resourceGroupName, resourceName, iotHubDescription, ifMatch, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (iotHubTags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubTags is required and cannot be null."));
        }
        iotHubTags.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, this.client.getApiVersion(), iotHubTags, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (iotHubTags == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubTags is required and cannot be null."));
        }
        iotHubTags.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, this.client.getApiVersion(), iotHubTags, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginUpdateAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceName, iotHubTags);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginUpdateAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, resourceName, iotHubTags, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginUpdate(String resourceGroupName, String resourceName, TagsResource iotHubTags) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, iotHubTags).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginUpdate(String resourceGroupName, String resourceName, TagsResource iotHubTags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, iotHubTags, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> updateAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, iotHubTags).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> updateAsync(String resourceGroupName, String resourceName, TagsResource iotHubTags, Context context) {
        return this.beginUpdateAsync(resourceGroupName, resourceName, iotHubTags, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner update(String resourceGroupName, String resourceName, TagsResource iotHubTags) {
        return (IotHubDescriptionInner)((Object)this.updateAsync(resourceGroupName, resourceName, iotHubTags).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner update(String resourceGroupName, String resourceName, TagsResource iotHubTags, Context context) {
        return (IotHubDescriptionInner)((Object)this.updateAsync(resourceGroupName, resourceName, iotHubTags, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginDeleteAsync(String resourceGroupName, String resourceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginDeleteAsync(String resourceGroupName, String resourceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, resourceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)IotHubDescriptionInner.class), (Type)((Object)IotHubDescriptionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginDelete(String resourceGroupName, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<IotHubDescriptionInner>, IotHubDescriptionInner> beginDelete(String resourceGroupName, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> deleteAsync(String resourceGroupName, String resourceName) {
        return this.beginDeleteAsync(resourceGroupName, resourceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubDescriptionInner> deleteAsync(String resourceGroupName, String resourceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, resourceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner delete(String resourceGroupName, String resourceName) {
        return (IotHubDescriptionInner)((Object)this.deleteAsync(resourceGroupName, resourceName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubDescriptionInner delete(String resourceGroupName, String resourceName, Context context) {
        return (IotHubDescriptionInner)((Object)this.deleteAsync(resourceGroupName, resourceName, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubDescriptionInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubDescriptionInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubDescriptionInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubDescriptionInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubDescriptionInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubDescriptionInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubDescriptionInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubDescriptionInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegistryStatisticsInner>> getStatsWithResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStats(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RegistryStatisticsInner>> getStatsWithResponseAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getStats(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RegistryStatisticsInner> getStatsAsync(String resourceGroupName, String resourceName) {
        return this.getStatsWithResponseAsync(resourceGroupName, resourceName).flatMap(res -> Mono.justOrEmpty((Object)((RegistryStatisticsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RegistryStatisticsInner> getStatsWithResponse(String resourceGroupName, String resourceName, Context context) {
        return (Response)this.getStatsWithResponseAsync(resourceGroupName, resourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RegistryStatisticsInner getStats(String resourceGroupName, String resourceName) {
        return (RegistryStatisticsInner)this.getStatsWithResponse(resourceGroupName, resourceName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubSkuDescriptionInner>> getValidSkusSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getValidSkus(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubSkuDescriptionListResult)res.getValue()).value(), ((IotHubSkuDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubSkuDescriptionInner>> getValidSkusSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getValidSkus(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubSkuDescriptionListResult)res.getValue()).value(), ((IotHubSkuDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubSkuDescriptionInner> getValidSkusAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.getValidSkusSinglePageAsync(resourceGroupName, resourceName), nextLink -> this.getValidSkusNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubSkuDescriptionInner> getValidSkusAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.getValidSkusSinglePageAsync(resourceGroupName, resourceName, context), nextLink -> this.getValidSkusNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubSkuDescriptionInner> getValidSkus(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.getValidSkusAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubSkuDescriptionInner> getValidSkus(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.getValidSkusAsync(resourceGroupName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventHubConsumerGroupInfoInner>> listEventHubConsumerGroupsSinglePageAsync(String resourceGroupName, String resourceName, String eventHubEndpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listEventHubConsumerGroups(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventHubConsumerGroupsListResult)res.getValue()).value(), ((EventHubConsumerGroupsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventHubConsumerGroupInfoInner>> listEventHubConsumerGroupsSinglePageAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listEventHubConsumerGroups(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventHubConsumerGroupsListResult)res.getValue()).value(), ((EventHubConsumerGroupsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventHubConsumerGroupInfoInner> listEventHubConsumerGroupsAsync(String resourceGroupName, String resourceName, String eventHubEndpointName) {
        return new PagedFlux(() -> this.listEventHubConsumerGroupsSinglePageAsync(resourceGroupName, resourceName, eventHubEndpointName), nextLink -> this.listEventHubConsumerGroupsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EventHubConsumerGroupInfoInner> listEventHubConsumerGroupsAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, Context context) {
        return new PagedFlux(() -> this.listEventHubConsumerGroupsSinglePageAsync(resourceGroupName, resourceName, eventHubEndpointName, context), nextLink -> this.listEventHubConsumerGroupsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventHubConsumerGroupInfoInner> listEventHubConsumerGroups(String resourceGroupName, String resourceName, String eventHubEndpointName) {
        return new PagedIterable(this.listEventHubConsumerGroupsAsync(resourceGroupName, resourceName, eventHubEndpointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EventHubConsumerGroupInfoInner> listEventHubConsumerGroups(String resourceGroupName, String resourceName, String eventHubEndpointName, Context context) {
        return new PagedIterable(this.listEventHubConsumerGroupsAsync(resourceGroupName, resourceName, eventHubEndpointName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventHubConsumerGroupInfoInner>> getEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventHubConsumerGroupInfoInner>> getEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventHubConsumerGroupInfoInner> getEventHubConsumerGroupAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        return this.getEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name).flatMap(res -> Mono.justOrEmpty((Object)((Object)((EventHubConsumerGroupInfoInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventHubConsumerGroupInfoInner> getEventHubConsumerGroupWithResponse(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        return (Response)this.getEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventHubConsumerGroupInfoInner getEventHubConsumerGroup(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        return (EventHubConsumerGroupInfoInner)((Object)this.getEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventHubConsumerGroupInfoInner>> createEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, EventHubConsumerGroupBodyDescription consumerGroupBody) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (consumerGroupBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupBody is required and cannot be null."));
        }
        consumerGroupBody.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, consumerGroupBody, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<EventHubConsumerGroupInfoInner>> createEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, EventHubConsumerGroupBodyDescription consumerGroupBody, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (consumerGroupBody == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter consumerGroupBody is required and cannot be null."));
        }
        consumerGroupBody.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, consumerGroupBody, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<EventHubConsumerGroupInfoInner> createEventHubConsumerGroupAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, EventHubConsumerGroupBodyDescription consumerGroupBody) {
        return this.createEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name, consumerGroupBody).flatMap(res -> Mono.justOrEmpty((Object)((Object)((EventHubConsumerGroupInfoInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<EventHubConsumerGroupInfoInner> createEventHubConsumerGroupWithResponse(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, EventHubConsumerGroupBodyDescription consumerGroupBody, Context context) {
        return (Response)this.createEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name, consumerGroupBody, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventHubConsumerGroupInfoInner createEventHubConsumerGroup(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, EventHubConsumerGroupBodyDescription consumerGroupBody) {
        return (EventHubConsumerGroupInfoInner)((Object)this.createEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, consumerGroupBody, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteEventHubConsumerGroupWithResponseAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (eventHubEndpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter eventHubEndpointName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteEventHubConsumerGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, eventHubEndpointName, name, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteEventHubConsumerGroupAsync(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        return this.deleteEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteEventHubConsumerGroupWithResponse(String resourceGroupName, String resourceName, String eventHubEndpointName, String name, Context context) {
        return (Response)this.deleteEventHubConsumerGroupWithResponseAsync(resourceGroupName, resourceName, eventHubEndpointName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEventHubConsumerGroup(String resourceGroupName, String resourceName, String eventHubEndpointName, String name) {
        this.deleteEventHubConsumerGroupWithResponse(resourceGroupName, resourceName, eventHubEndpointName, name, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResponseInner>> listJobsSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobs(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResponseListResult)res.getValue()).value(), ((JobResponseListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResponseInner>> listJobsSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listJobs(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResponseListResult)res.getValue()).value(), ((JobResponseListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResponseInner> listJobsAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.listJobsSinglePageAsync(resourceGroupName, resourceName), nextLink -> this.listJobsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobResponseInner> listJobsAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listJobsSinglePageAsync(resourceGroupName, resourceName, context), nextLink -> this.listJobsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResponseInner> listJobs(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.listJobsAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobResponseInner> listJobs(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.listJobsAsync(resourceGroupName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> getJobWithResponseAsync(String resourceGroupName, String resourceName, String jobId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (jobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getJob(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, jobId, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> getJobWithResponseAsync(String resourceGroupName, String resourceName, String jobId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (jobId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter jobId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getJob(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, jobId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResponseInner> getJobAsync(String resourceGroupName, String resourceName, String jobId) {
        return this.getJobWithResponseAsync(resourceGroupName, resourceName, jobId).flatMap(res -> Mono.justOrEmpty((Object)((JobResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobResponseInner> getJobWithResponse(String resourceGroupName, String resourceName, String jobId, Context context) {
        return (Response)this.getJobWithResponseAsync(resourceGroupName, resourceName, jobId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResponseInner getJob(String resourceGroupName, String resourceName, String jobId) {
        return (JobResponseInner)this.getJobWithResponse(resourceGroupName, resourceName, jobId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubQuotaMetricInfoInner>> getQuotaMetricsSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getQuotaMetrics(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubQuotaMetricInfoListResult)res.getValue()).value(), ((IotHubQuotaMetricInfoListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubQuotaMetricInfoInner>> getQuotaMetricsSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getQuotaMetrics(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubQuotaMetricInfoListResult)res.getValue()).value(), ((IotHubQuotaMetricInfoListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubQuotaMetricInfoInner> getQuotaMetricsAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.getQuotaMetricsSinglePageAsync(resourceGroupName, resourceName), nextLink -> this.getQuotaMetricsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IotHubQuotaMetricInfoInner> getQuotaMetricsAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.getQuotaMetricsSinglePageAsync(resourceGroupName, resourceName, context), nextLink -> this.getQuotaMetricsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubQuotaMetricInfoInner> getQuotaMetrics(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.getQuotaMetricsAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IotHubQuotaMetricInfoInner> getQuotaMetrics(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.getQuotaMetricsAsync(resourceGroupName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointHealthDataInner>> getEndpointHealthSinglePageAsync(String resourceGroupName, String iotHubName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEndpointHealth(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, iotHubName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointHealthDataListResult)res.getValue()).value(), ((EndpointHealthDataListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointHealthDataInner>> getEndpointHealthSinglePageAsync(String resourceGroupName, String iotHubName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEndpointHealth(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, iotHubName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointHealthDataListResult)res.getValue()).value(), ((EndpointHealthDataListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EndpointHealthDataInner> getEndpointHealthAsync(String resourceGroupName, String iotHubName) {
        return new PagedFlux(() -> this.getEndpointHealthSinglePageAsync(resourceGroupName, iotHubName), nextLink -> this.getEndpointHealthNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<EndpointHealthDataInner> getEndpointHealthAsync(String resourceGroupName, String iotHubName, Context context) {
        return new PagedFlux(() -> this.getEndpointHealthSinglePageAsync(resourceGroupName, iotHubName, context), nextLink -> this.getEndpointHealthNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EndpointHealthDataInner> getEndpointHealth(String resourceGroupName, String iotHubName) {
        return new PagedIterable(this.getEndpointHealthAsync(resourceGroupName, iotHubName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EndpointHealthDataInner> getEndpointHealth(String resourceGroupName, String iotHubName, Context context) {
        return new PagedIterable(this.getEndpointHealthAsync(resourceGroupName, iotHubName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IotHubNameAvailabilityInfoInner>> checkNameAvailabilityWithResponseAsync(OperationInputs operationInputs) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (operationInputs == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationInputs is required and cannot be null."));
        }
        operationInputs.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), operationInputs, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IotHubNameAvailabilityInfoInner>> checkNameAvailabilityWithResponseAsync(OperationInputs operationInputs, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (operationInputs == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationInputs is required and cannot be null."));
        }
        operationInputs.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), operationInputs, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<IotHubNameAvailabilityInfoInner> checkNameAvailabilityAsync(OperationInputs operationInputs) {
        return this.checkNameAvailabilityWithResponseAsync(operationInputs).flatMap(res -> Mono.justOrEmpty((Object)((IotHubNameAvailabilityInfoInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IotHubNameAvailabilityInfoInner> checkNameAvailabilityWithResponse(OperationInputs operationInputs, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(operationInputs, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IotHubNameAvailabilityInfoInner checkNameAvailability(OperationInputs operationInputs) {
        return (IotHubNameAvailabilityInfoInner)this.checkNameAvailabilityWithResponse(operationInputs, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestAllRoutesResultInner>> testAllRoutesWithResponseAsync(String iotHubName, String resourceGroupName, TestAllRoutesInput input) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.testAllRoutes(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), input, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestAllRoutesResultInner>> testAllRoutesWithResponseAsync(String iotHubName, String resourceGroupName, TestAllRoutesInput input, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.testAllRoutes(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), input, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestAllRoutesResultInner> testAllRoutesAsync(String iotHubName, String resourceGroupName, TestAllRoutesInput input) {
        return this.testAllRoutesWithResponseAsync(iotHubName, resourceGroupName, input).flatMap(res -> Mono.justOrEmpty((Object)((TestAllRoutesResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestAllRoutesResultInner> testAllRoutesWithResponse(String iotHubName, String resourceGroupName, TestAllRoutesInput input, Context context) {
        return (Response)this.testAllRoutesWithResponseAsync(iotHubName, resourceGroupName, input, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestAllRoutesResultInner testAllRoutes(String iotHubName, String resourceGroupName, TestAllRoutesInput input) {
        return (TestAllRoutesResultInner)this.testAllRoutesWithResponse(iotHubName, resourceGroupName, input, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestRouteResultInner>> testRouteWithResponseAsync(String iotHubName, String resourceGroupName, TestRouteInput input) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.testRoute(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), input, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TestRouteResultInner>> testRouteWithResponseAsync(String iotHubName, String resourceGroupName, TestRouteInput input, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (input == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter input is required and cannot be null."));
        }
        input.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.testRoute(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), input, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TestRouteResultInner> testRouteAsync(String iotHubName, String resourceGroupName, TestRouteInput input) {
        return this.testRouteWithResponseAsync(iotHubName, resourceGroupName, input).flatMap(res -> Mono.justOrEmpty((Object)((TestRouteResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TestRouteResultInner> testRouteWithResponse(String iotHubName, String resourceGroupName, TestRouteInput input, Context context) {
        return (Response)this.testRouteWithResponseAsync(iotHubName, resourceGroupName, input, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRouteResultInner testRoute(String iotHubName, String resourceGroupName, TestRouteInput input) {
        return (TestRouteResultInner)this.testRouteWithResponse(iotHubName, resourceGroupName, input, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedAccessSignatureAuthorizationRuleInner>> listKeysSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listKeys(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedAccessSignatureAuthorizationRuleInner>> listKeysSinglePageAsync(String resourceGroupName, String resourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listKeys(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SharedAccessSignatureAuthorizationRuleInner> listKeysAsync(String resourceGroupName, String resourceName) {
        return new PagedFlux(() -> this.listKeysSinglePageAsync(resourceGroupName, resourceName), nextLink -> this.listKeysNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SharedAccessSignatureAuthorizationRuleInner> listKeysAsync(String resourceGroupName, String resourceName, Context context) {
        return new PagedFlux(() -> this.listKeysSinglePageAsync(resourceGroupName, resourceName, context), nextLink -> this.listKeysNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SharedAccessSignatureAuthorizationRuleInner> listKeys(String resourceGroupName, String resourceName) {
        return new PagedIterable(this.listKeysAsync(resourceGroupName, resourceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SharedAccessSignatureAuthorizationRuleInner> listKeys(String resourceGroupName, String resourceName, Context context) {
        return new PagedIterable(this.listKeysAsync(resourceGroupName, resourceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SharedAccessSignatureAuthorizationRuleInner>> getKeysForKeyNameWithResponseAsync(String resourceGroupName, String resourceName, String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getKeysForKeyName(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, keyName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SharedAccessSignatureAuthorizationRuleInner>> getKeysForKeyNameWithResponseAsync(String resourceGroupName, String resourceName, String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getKeysForKeyName(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, keyName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SharedAccessSignatureAuthorizationRuleInner> getKeysForKeyNameAsync(String resourceGroupName, String resourceName, String keyName) {
        return this.getKeysForKeyNameWithResponseAsync(resourceGroupName, resourceName, keyName).flatMap(res -> Mono.justOrEmpty((Object)((SharedAccessSignatureAuthorizationRuleInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SharedAccessSignatureAuthorizationRuleInner> getKeysForKeyNameWithResponse(String resourceGroupName, String resourceName, String keyName, Context context) {
        return (Response)this.getKeysForKeyNameWithResponseAsync(resourceGroupName, resourceName, keyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SharedAccessSignatureAuthorizationRuleInner getKeysForKeyName(String resourceGroupName, String resourceName, String keyName) {
        return (SharedAccessSignatureAuthorizationRuleInner)this.getKeysForKeyNameWithResponse(resourceGroupName, resourceName, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> exportDevicesWithResponseAsync(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (exportDevicesParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportDevicesParameters is required and cannot be null."));
        }
        exportDevicesParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.exportDevices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, exportDevicesParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> exportDevicesWithResponseAsync(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (exportDevicesParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter exportDevicesParameters is required and cannot be null."));
        }
        exportDevicesParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.exportDevices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, exportDevicesParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResponseInner> exportDevicesAsync(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters) {
        return this.exportDevicesWithResponseAsync(resourceGroupName, resourceName, exportDevicesParameters).flatMap(res -> Mono.justOrEmpty((Object)((JobResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobResponseInner> exportDevicesWithResponse(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters, Context context) {
        return (Response)this.exportDevicesWithResponseAsync(resourceGroupName, resourceName, exportDevicesParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResponseInner exportDevices(String resourceGroupName, String resourceName, ExportDevicesRequest exportDevicesParameters) {
        return (JobResponseInner)this.exportDevicesWithResponse(resourceGroupName, resourceName, exportDevicesParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> importDevicesWithResponseAsync(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (importDevicesParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importDevicesParameters is required and cannot be null."));
        }
        importDevicesParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.importDevices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, importDevicesParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobResponseInner>> importDevicesWithResponseAsync(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (importDevicesParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importDevicesParameters is required and cannot be null."));
        }
        importDevicesParameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.importDevices(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, resourceName, importDevicesParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobResponseInner> importDevicesAsync(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters) {
        return this.importDevicesWithResponseAsync(resourceGroupName, resourceName, importDevicesParameters).flatMap(res -> Mono.justOrEmpty((Object)((JobResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobResponseInner> importDevicesWithResponse(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters, Context context) {
        return (Response)this.importDevicesWithResponseAsync(resourceGroupName, resourceName, importDevicesParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobResponseInner importDevices(String resourceGroupName, String resourceName, ImportDevicesRequest importDevicesParameters) {
        return (JobResponseInner)this.importDevicesWithResponse(resourceGroupName, resourceName, importDevicesParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubDescriptionInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubDescriptionListResult)res.getValue()).value(), ((IotHubDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubSkuDescriptionInner>> getValidSkusNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getValidSkusNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubSkuDescriptionListResult)res.getValue()).value(), ((IotHubSkuDescriptionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubSkuDescriptionInner>> getValidSkusNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getValidSkusNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubSkuDescriptionListResult)res.getValue()).value(), ((IotHubSkuDescriptionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventHubConsumerGroupInfoInner>> listEventHubConsumerGroupsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listEventHubConsumerGroupsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventHubConsumerGroupsListResult)res.getValue()).value(), ((EventHubConsumerGroupsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EventHubConsumerGroupInfoInner>> listEventHubConsumerGroupsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listEventHubConsumerGroupsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EventHubConsumerGroupsListResult)res.getValue()).value(), ((EventHubConsumerGroupsListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResponseInner>> listJobsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listJobsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResponseListResult)res.getValue()).value(), ((JobResponseListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobResponseInner>> listJobsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listJobsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobResponseListResult)res.getValue()).value(), ((JobResponseListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubQuotaMetricInfoInner>> getQuotaMetricsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getQuotaMetricsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubQuotaMetricInfoListResult)res.getValue()).value(), ((IotHubQuotaMetricInfoListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IotHubQuotaMetricInfoInner>> getQuotaMetricsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getQuotaMetricsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IotHubQuotaMetricInfoListResult)res.getValue()).value(), ((IotHubQuotaMetricInfoListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointHealthDataInner>> getEndpointHealthNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getEndpointHealthNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointHealthDataListResult)res.getValue()).value(), ((EndpointHealthDataListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointHealthDataInner>> getEndpointHealthNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getEndpointHealthNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((EndpointHealthDataListResult)res.getValue()).value(), ((EndpointHealthDataListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedAccessSignatureAuthorizationRuleInner>> listKeysNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listKeysNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SharedAccessSignatureAuthorizationRuleInner>> listKeysNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listKeysNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).value(), ((SharedAccessSignatureAuthorizationRuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientIotHubRe")
    public static interface IotHubResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubDescriptionInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="If-Match") String var6, @BodyParam(value="application/json") IotHubDescriptionInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TagsResource var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}")
        @ExpectedResponses(value={200, 202, 204, 404})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubDescriptionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubDescriptionListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<RegistryStatisticsInner>> getStats(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubSkuDescriptionListResult>> getValidSkus(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EventHubConsumerGroupsListResult>> listEventHubConsumerGroups(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="eventHubEndpointName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EventHubConsumerGroupInfoInner>> getEventHubConsumerGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="eventHubEndpointName") String var6, @PathParam(value="name") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EventHubConsumerGroupInfoInner>> createEventHubConsumerGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="eventHubEndpointName") String var6, @PathParam(value="name") String var7, @BodyParam(value="application/json") EventHubConsumerGroupBodyDescription var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Void>> deleteEventHubConsumerGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="eventHubEndpointName") String var6, @PathParam(value="name") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<JobResponseListResult>> listJobs(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<JobResponseInner>> getJob(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="jobId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubQuotaMetricInfoListResult>> getQuotaMetrics(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routingEndpointsHealth")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EndpointHealthDataListResult>> getEndpointHealth(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="iotHubName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubNameAvailabilityInfoInner>> checkNameAvailability(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") OperationInputs var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testall")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<TestAllRoutesResultInner>> testAllRoutes(@HostParam(value="$host") String var1, @PathParam(value="iotHubName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TestAllRoutesInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/routing/routes/$testnew")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<TestRouteResultInner>> testRoute(@HostParam(value="$host") String var1, @PathParam(value="iotHubName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") TestRouteInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<SharedAccessSignatureAuthorizationRuleListResult>> listKeys(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<SharedAccessSignatureAuthorizationRuleInner>> getKeysForKeyName(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @PathParam(value="keyName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<JobResponseInner>> exportDevices(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") ExportDevicesRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<JobResponseInner>> importDevices(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="resourceName") String var5, @BodyParam(value="application/json") ImportDevicesRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubDescriptionListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubDescriptionListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubSkuDescriptionListResult>> getValidSkusNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EventHubConsumerGroupsListResult>> listEventHubConsumerGroupsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<JobResponseListResult>> listJobsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<IotHubQuotaMetricInfoListResult>> getQuotaMetricsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<EndpointHealthDataListResult>> getEndpointHealthNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<SharedAccessSignatureAuthorizationRuleListResult>> listKeysNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

