/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.iothub.fluent.IotHubsClient;
import com.azure.resourcemanager.iothub.implementation.IotHubClientImpl;
import com.azure.resourcemanager.iothub.models.ErrorDetailsException;
import com.azure.resourcemanager.iothub.models.FailoverInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class IotHubsClientImpl
implements IotHubsClient {
    private final IotHubsService service;
    private final IotHubClientImpl client;

    IotHubsClientImpl(IotHubClientImpl client) {
        this.service = (IotHubsService)RestProxy.create(IotHubsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> manualFailoverWithResponseAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (failoverInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter failoverInput is required and cannot be null."));
        }
        failoverInput.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.manualFailover(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), failoverInput, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> manualFailoverWithResponseAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (iotHubName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter iotHubName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (failoverInput == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter failoverInput is required and cannot be null."));
        }
        failoverInput.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.manualFailover(this.client.getEndpoint(), iotHubName, this.client.getSubscriptionId(), resourceGroupName, this.client.getApiVersion(), failoverInput, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginManualFailoverAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.manualFailoverWithResponseAsync(iotHubName, resourceGroupName, failoverInput);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginManualFailoverAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.manualFailoverWithResponseAsync(iotHubName, resourceGroupName, failoverInput, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginManualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        return this.beginManualFailoverAsync(iotHubName, resourceGroupName, failoverInput).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginManualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        return this.beginManualFailoverAsync(iotHubName, resourceGroupName, failoverInput, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> manualFailoverAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        return this.beginManualFailoverAsync(iotHubName, resourceGroupName, failoverInput).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> manualFailoverAsync(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        return this.beginManualFailoverAsync(iotHubName, resourceGroupName, failoverInput, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void manualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput) {
        this.manualFailoverAsync(iotHubName, resourceGroupName, failoverInput).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void manualFailover(String iotHubName, String resourceGroupName, FailoverInput failoverInput, Context context) {
        this.manualFailoverAsync(iotHubName, resourceGroupName, failoverInput, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="IotHubClientIotHubs")
    public static interface IotHubsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{iotHubName}/failover")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ErrorDetailsException.class)
        public Mono<Response<Flux<ByteBuffer>>> manualFailover(@HostParam(value="$host") String var1, @PathParam(value="iotHubName") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") FailoverInput var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

