/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.iothub.models.AuthenticationType;
import com.azure.resourcemanager.iothub.models.ManagedIdentity;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportDevicesRequest {
    @JsonProperty(value="inputBlobContainerUri", required=true)
    private String inputBlobContainerUri;
    @JsonProperty(value="outputBlobContainerUri", required=true)
    private String outputBlobContainerUri;
    @JsonProperty(value="inputBlobName")
    private String inputBlobName;
    @JsonProperty(value="outputBlobName")
    private String outputBlobName;
    @JsonProperty(value="authenticationType")
    private AuthenticationType authenticationType;
    @JsonProperty(value="identity")
    private ManagedIdentity identity;
    @JsonProperty(value="includeConfigurations")
    private Boolean includeConfigurations;
    @JsonProperty(value="configurationsBlobName")
    private String configurationsBlobName;
    private static final ClientLogger LOGGER = new ClientLogger(ImportDevicesRequest.class);

    public String inputBlobContainerUri() {
        return this.inputBlobContainerUri;
    }

    public ImportDevicesRequest withInputBlobContainerUri(String inputBlobContainerUri) {
        this.inputBlobContainerUri = inputBlobContainerUri;
        return this;
    }

    public String outputBlobContainerUri() {
        return this.outputBlobContainerUri;
    }

    public ImportDevicesRequest withOutputBlobContainerUri(String outputBlobContainerUri) {
        this.outputBlobContainerUri = outputBlobContainerUri;
        return this;
    }

    public String inputBlobName() {
        return this.inputBlobName;
    }

    public ImportDevicesRequest withInputBlobName(String inputBlobName) {
        this.inputBlobName = inputBlobName;
        return this;
    }

    public String outputBlobName() {
        return this.outputBlobName;
    }

    public ImportDevicesRequest withOutputBlobName(String outputBlobName) {
        this.outputBlobName = outputBlobName;
        return this;
    }

    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public ImportDevicesRequest withAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public ManagedIdentity identity() {
        return this.identity;
    }

    public ImportDevicesRequest withIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Boolean includeConfigurations() {
        return this.includeConfigurations;
    }

    public ImportDevicesRequest withIncludeConfigurations(Boolean includeConfigurations) {
        this.includeConfigurations = includeConfigurations;
        return this;
    }

    public String configurationsBlobName() {
        return this.configurationsBlobName;
    }

    public ImportDevicesRequest withConfigurationsBlobName(String configurationsBlobName) {
        this.configurationsBlobName = configurationsBlobName;
        return this;
    }

    public void validate() {
        if (this.inputBlobContainerUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property inputBlobContainerUri in model ImportDevicesRequest"));
        }
        if (this.outputBlobContainerUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property outputBlobContainerUri in model ImportDevicesRequest"));
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

