/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.iothub.models;

import com.azure.resourcemanager.iothub.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.iothub.fluent.models.SharedAccessSignatureAuthorizationRuleInner;
import com.azure.resourcemanager.iothub.models.Capabilities;
import com.azure.resourcemanager.iothub.models.CloudToDeviceProperties;
import com.azure.resourcemanager.iothub.models.EventHubProperties;
import com.azure.resourcemanager.iothub.models.IotHubLocationDescription;
import com.azure.resourcemanager.iothub.models.IpFilterRule;
import com.azure.resourcemanager.iothub.models.MessagingEndpointProperties;
import com.azure.resourcemanager.iothub.models.NetworkRuleSetProperties;
import com.azure.resourcemanager.iothub.models.PublicNetworkAccess;
import com.azure.resourcemanager.iothub.models.RoutingProperties;
import com.azure.resourcemanager.iothub.models.StorageEndpointProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class IotHubProperties {
    @JsonProperty(value="authorizationPolicies")
    private List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies;
    @JsonProperty(value="disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="disableDeviceSAS")
    private Boolean disableDeviceSas;
    @JsonProperty(value="disableModuleSAS")
    private Boolean disableModuleSas;
    @JsonProperty(value="restrictOutboundNetworkAccess")
    private Boolean restrictOutboundNetworkAccess;
    @JsonProperty(value="allowedFqdnList")
    private List<String> allowedFqdnList;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="ipFilterRules")
    private List<IpFilterRule> ipFilterRules;
    @JsonProperty(value="networkRuleSets")
    private NetworkRuleSetProperties networkRuleSets;
    @JsonProperty(value="minTlsVersion")
    private String minTlsVersion;
    @JsonProperty(value="privateEndpointConnections")
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="hostName", access=JsonProperty.Access.WRITE_ONLY)
    private String hostname;
    @JsonProperty(value="eventHubEndpoints")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, EventHubProperties> eventHubEndpoints;
    @JsonProperty(value="routing")
    private RoutingProperties routing;
    @JsonProperty(value="storageEndpoints")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, StorageEndpointProperties> storageEndpoints;
    @JsonProperty(value="messagingEndpoints")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, MessagingEndpointProperties> messagingEndpoints;
    @JsonProperty(value="enableFileUploadNotifications")
    private Boolean enableFileUploadNotifications;
    @JsonProperty(value="cloudToDevice")
    private CloudToDeviceProperties cloudToDevice;
    @JsonProperty(value="comments")
    private String comments;
    @JsonProperty(value="features")
    private Capabilities features;
    @JsonProperty(value="locations", access=JsonProperty.Access.WRITE_ONLY)
    private List<IotHubLocationDescription> locations;
    @JsonProperty(value="enableDataResidency")
    private Boolean enableDataResidency;

    public List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies() {
        return this.authorizationPolicies;
    }

    public IotHubProperties withAuthorizationPolicies(List<SharedAccessSignatureAuthorizationRuleInner> authorizationPolicies) {
        this.authorizationPolicies = authorizationPolicies;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public IotHubProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Boolean disableDeviceSas() {
        return this.disableDeviceSas;
    }

    public IotHubProperties withDisableDeviceSas(Boolean disableDeviceSas) {
        this.disableDeviceSas = disableDeviceSas;
        return this;
    }

    public Boolean disableModuleSas() {
        return this.disableModuleSas;
    }

    public IotHubProperties withDisableModuleSas(Boolean disableModuleSas) {
        this.disableModuleSas = disableModuleSas;
        return this;
    }

    public Boolean restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public IotHubProperties withRestrictOutboundNetworkAccess(Boolean restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public List<String> allowedFqdnList() {
        return this.allowedFqdnList;
    }

    public IotHubProperties withAllowedFqdnList(List<String> allowedFqdnList) {
        this.allowedFqdnList = allowedFqdnList;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public IotHubProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<IpFilterRule> ipFilterRules() {
        return this.ipFilterRules;
    }

    public IotHubProperties withIpFilterRules(List<IpFilterRule> ipFilterRules) {
        this.ipFilterRules = ipFilterRules;
        return this;
    }

    public NetworkRuleSetProperties networkRuleSets() {
        return this.networkRuleSets;
    }

    public IotHubProperties withNetworkRuleSets(NetworkRuleSetProperties networkRuleSets) {
        this.networkRuleSets = networkRuleSets;
        return this;
    }

    public String minTlsVersion() {
        return this.minTlsVersion;
    }

    public IotHubProperties withMinTlsVersion(String minTlsVersion) {
        this.minTlsVersion = minTlsVersion;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public IotHubProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String state() {
        return this.state;
    }

    public String hostname() {
        return this.hostname;
    }

    public Map<String, EventHubProperties> eventHubEndpoints() {
        return this.eventHubEndpoints;
    }

    public IotHubProperties withEventHubEndpoints(Map<String, EventHubProperties> eventHubEndpoints) {
        this.eventHubEndpoints = eventHubEndpoints;
        return this;
    }

    public RoutingProperties routing() {
        return this.routing;
    }

    public IotHubProperties withRouting(RoutingProperties routing) {
        this.routing = routing;
        return this;
    }

    public Map<String, StorageEndpointProperties> storageEndpoints() {
        return this.storageEndpoints;
    }

    public IotHubProperties withStorageEndpoints(Map<String, StorageEndpointProperties> storageEndpoints) {
        this.storageEndpoints = storageEndpoints;
        return this;
    }

    public Map<String, MessagingEndpointProperties> messagingEndpoints() {
        return this.messagingEndpoints;
    }

    public IotHubProperties withMessagingEndpoints(Map<String, MessagingEndpointProperties> messagingEndpoints) {
        this.messagingEndpoints = messagingEndpoints;
        return this;
    }

    public Boolean enableFileUploadNotifications() {
        return this.enableFileUploadNotifications;
    }

    public IotHubProperties withEnableFileUploadNotifications(Boolean enableFileUploadNotifications) {
        this.enableFileUploadNotifications = enableFileUploadNotifications;
        return this;
    }

    public CloudToDeviceProperties cloudToDevice() {
        return this.cloudToDevice;
    }

    public IotHubProperties withCloudToDevice(CloudToDeviceProperties cloudToDevice) {
        this.cloudToDevice = cloudToDevice;
        return this;
    }

    public String comments() {
        return this.comments;
    }

    public IotHubProperties withComments(String comments) {
        this.comments = comments;
        return this;
    }

    public Capabilities features() {
        return this.features;
    }

    public IotHubProperties withFeatures(Capabilities features) {
        this.features = features;
        return this;
    }

    public List<IotHubLocationDescription> locations() {
        return this.locations;
    }

    public Boolean enableDataResidency() {
        return this.enableDataResidency;
    }

    public IotHubProperties withEnableDataResidency(Boolean enableDataResidency) {
        this.enableDataResidency = enableDataResidency;
        return this;
    }

    public void validate() {
        if (this.authorizationPolicies() != null) {
            this.authorizationPolicies().forEach(e -> e.validate());
        }
        if (this.ipFilterRules() != null) {
            this.ipFilterRules().forEach(e -> e.validate());
        }
        if (this.networkRuleSets() != null) {
            this.networkRuleSets().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.eventHubEndpoints() != null) {
            this.eventHubEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.routing() != null) {
            this.routing().validate();
        }
        if (this.storageEndpoints() != null) {
            this.storageEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.messagingEndpoints() != null) {
            this.messagingEndpoints().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.cloudToDevice() != null) {
            this.cloudToDevice().validate();
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
    }
}

