/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.recoveryservices.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.recoveryservices.RecoveryServicesManager;
import com.azure.resourcemanager.recoveryservices.fluent.models.VaultCertificateResponseInner;
import com.azure.resourcemanager.recoveryservices.models.CertificateRequest;
import com.azure.resourcemanager.recoveryservices.models.RawCertificateData;
import com.azure.resourcemanager.recoveryservices.models.ResourceCertificateDetails;
import com.azure.resourcemanager.recoveryservices.models.VaultCertificateResponse;

public final class VaultCertificateResponseImpl
implements VaultCertificateResponse,
VaultCertificateResponse.Definition {
    private VaultCertificateResponseInner innerObject;
    private final RecoveryServicesManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private String certificateName;
    private CertificateRequest createCertificateRequest;

    VaultCertificateResponseImpl(VaultCertificateResponseInner innerObject, RecoveryServicesManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ResourceCertificateDetails properties() {
        return this.innerModel().properties();
    }

    @Override
    public VaultCertificateResponseInner innerModel() {
        return this.innerObject;
    }

    private RecoveryServicesManager manager() {
        return this.serviceManager;
    }

    @Override
    public VaultCertificateResponseImpl withExistingVault(String resourceGroupName, String vaultName) {
        this.resourceGroupName = resourceGroupName;
        this.vaultName = vaultName;
        return this;
    }

    @Override
    public VaultCertificateResponse create() {
        this.innerObject = (VaultCertificateResponseInner)((Object)this.serviceManager.serviceClient().getVaultCertificates().createWithResponse(this.resourceGroupName, this.vaultName, this.certificateName, this.createCertificateRequest, Context.NONE).getValue());
        return this;
    }

    @Override
    public VaultCertificateResponse create(Context context) {
        this.innerObject = (VaultCertificateResponseInner)((Object)this.serviceManager.serviceClient().getVaultCertificates().createWithResponse(this.resourceGroupName, this.vaultName, this.certificateName, this.createCertificateRequest, context).getValue());
        return this;
    }

    VaultCertificateResponseImpl(String name, RecoveryServicesManager serviceManager) {
        this.innerObject = new VaultCertificateResponseInner();
        this.serviceManager = serviceManager;
        this.certificateName = name;
        this.createCertificateRequest = new CertificateRequest();
    }

    @Override
    public VaultCertificateResponseImpl withProperties(RawCertificateData properties) {
        this.createCertificateRequest.withProperties(properties);
        return this;
    }
}

