/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.redis.fluent.AccessPolicyAssignmentsClient;
import com.azure.resourcemanager.redis.fluent.models.RedisCacheAccessPolicyAssignmentInner;
import com.azure.resourcemanager.redis.implementation.RedisManagementClientImpl;
import com.azure.resourcemanager.redis.models.RedisCacheAccessPolicyAssignmentList;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AccessPolicyAssignmentsClientImpl
implements AccessPolicyAssignmentsClient {
    private final AccessPolicyAssignmentsService service;
    private final RedisManagementClientImpl client;

    AccessPolicyAssignmentsClientImpl(RedisManagementClientImpl client) {
        this.service = (AccessPolicyAssignmentsService)RestProxy.create(AccessPolicyAssignmentsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createUpdate(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner> beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RedisCacheAccessPolicyAssignmentInner.class), (Type)((Object)RedisCacheAccessPolicyAssignmentInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner> beginCreateUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createUpdateWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RedisCacheAccessPolicyAssignmentInner.class), (Type)((Object)RedisCacheAccessPolicyAssignmentInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner> beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RedisCacheAccessPolicyAssignmentInner>, RedisCacheAccessPolicyAssignmentInner> beginCreateUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyAssignmentInner> createUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RedisCacheAccessPolicyAssignmentInner> createUpdateAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return this.beginCreateUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters) {
        return (RedisCacheAccessPolicyAssignmentInner)((Object)this.createUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner createUpdate(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, RedisCacheAccessPolicyAssignmentInner parameters, Context context) {
        return (RedisCacheAccessPolicyAssignmentInner)((Object)this.createUpdateAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, parameters, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).last().flatMap(arg_0 -> ((RedisManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        this.deleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        this.deleteAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RedisCacheAccessPolicyAssignmentInner>> getWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RedisCacheAccessPolicyAssignmentInner>> getWithResponseAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (accessPolicyAssignmentName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter accessPolicyAssignmentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, cacheName, accessPolicyAssignmentName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RedisCacheAccessPolicyAssignmentInner> getAsync(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        return this.getWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((RedisCacheAccessPolicyAssignmentInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RedisCacheAccessPolicyAssignmentInner> getWithResponse(String resourceGroupName, String cacheName, String accessPolicyAssignmentName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, cacheName, accessPolicyAssignmentName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RedisCacheAccessPolicyAssignmentInner get(String resourceGroupName, String cacheName, String accessPolicyAssignmentName) {
        return (RedisCacheAccessPolicyAssignmentInner)((Object)this.getWithResponse(resourceGroupName, cacheName, accessPolicyAssignmentName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).value(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listSinglePageAsync(String resourceGroupName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).value(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RedisCacheAccessPolicyAssignmentInner> listAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, cacheName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RedisCacheAccessPolicyAssignmentInner> listAsync(String resourceGroupName, String cacheName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, cacheName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName) {
        return new PagedIterable(this.listAsync(resourceGroupName, cacheName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RedisCacheAccessPolicyAssignmentInner> list(String resourceGroupName, String cacheName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, cacheName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).value(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RedisCacheAccessPolicyAssignmentInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).value(), ((RedisCacheAccessPolicyAssignmentList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisManagementClien")
    public static interface AccessPolicyAssignmentsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyAssignmentName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") RedisCacheAccessPolicyAssignmentInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyAssignmentName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments/{accessPolicyAssignmentName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyAssignmentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @PathParam(value="accessPolicyAssignmentName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/accessPolicyAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyAssignmentList>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RedisCacheAccessPolicyAssignmentList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

