/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resourcegraph.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resourcegraph.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.resourcegraph.fluent.models.QueryResponseInner;
import com.azure.resourcemanager.resourcegraph.implementation.ResourceGraphClientImpl;
import com.azure.resourcemanager.resourcegraph.models.QueryRequest;
import reactor.core.publisher.Mono;

public final class ResourceProvidersClientImpl
implements ResourceProvidersClient {
    private final ResourceProvidersService service;
    private final ResourceGraphClientImpl client;

    ResourceProvidersClientImpl(ResourceGraphClientImpl client) {
        this.service = (ResourceProvidersService)RestProxy.create(ResourceProvidersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResponseInner>> resourcesWithResponseAsync(QueryRequest query) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (query == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter query is required and cannot be null."));
        }
        query.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resources(this.client.getEndpoint(), this.client.getApiVersion(), query, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<QueryResponseInner>> resourcesWithResponseAsync(QueryRequest query, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (query == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter query is required and cannot be null."));
        }
        query.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resources(this.client.getEndpoint(), this.client.getApiVersion(), query, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<QueryResponseInner> resourcesAsync(QueryRequest query) {
        return this.resourcesWithResponseAsync(query).flatMap(res -> Mono.justOrEmpty((Object)((QueryResponseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueryResponseInner> resourcesWithResponse(QueryRequest query, Context context) {
        return (Response)this.resourcesWithResponseAsync(query, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueryResponseInner resources(QueryRequest query) {
        return (QueryResponseInner)this.resourcesWithResponse(query, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ResourceGraphClientR")
    private static interface ResourceProvidersService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.ResourceGraph/resources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<QueryResponseInner>> resources(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") QueryRequest var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

