/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.azure.resourcemanager.resources.fluent.models.DeploymentExtendedInner;
import com.azure.resourcemanager.resources.fluent.models.DeploymentInner;
import com.azure.resourcemanager.resources.fluent.models.ProviderInner;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.implementation.DeploymentExportResultImpl;
import com.azure.resourcemanager.resources.implementation.DeploymentOperationsImpl;
import com.azure.resourcemanager.resources.implementation.ProviderImpl;
import com.azure.resourcemanager.resources.implementation.WhatIfOperationResultImpl;
import com.azure.resourcemanager.resources.models.DebugSetting;
import com.azure.resourcemanager.resources.models.Dependency;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentExportResult;
import com.azure.resourcemanager.resources.models.DeploymentMode;
import com.azure.resourcemanager.resources.models.DeploymentOperations;
import com.azure.resourcemanager.resources.models.DeploymentParameter;
import com.azure.resourcemanager.resources.models.DeploymentProperties;
import com.azure.resourcemanager.resources.models.DeploymentWhatIf;
import com.azure.resourcemanager.resources.models.DeploymentWhatIfProperties;
import com.azure.resourcemanager.resources.models.DeploymentWhatIfSettings;
import com.azure.resourcemanager.resources.models.OnErrorDeployment;
import com.azure.resourcemanager.resources.models.OnErrorDeploymentType;
import com.azure.resourcemanager.resources.models.ParametersLink;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.ResourceReference;
import com.azure.resourcemanager.resources.models.TemplateLink;
import com.azure.resourcemanager.resources.models.WhatIfOperationResult;
import com.azure.resourcemanager.resources.models.WhatIfResultFormat;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DeploymentImpl
extends CreatableUpdatableImpl<Deployment, DeploymentExtendedInner, DeploymentImpl>
implements Deployment,
Deployment.Definition,
Deployment.Update,
Deployment.Execution {
    private final ClientLogger logger = new ClientLogger(DeploymentImpl.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final SerializerAdapter SERIALIZER_ADAPTER = SerializerFactory.createDefaultManagementSerializerAdapter();
    private static final TypeReference<Map<String, DeploymentParameter>> TYPE_REFERENCE_MAP_DEPLOYMENT_PARAMETER = new TypeReference<Map<String, DeploymentParameter>>(){};
    private final ResourceManager resourceManager;
    private String resourceGroupName;
    private Creatable<ResourceGroup> creatableResourceGroup;
    private DeploymentWhatIf deploymentWhatIf;
    private DeploymentInner deploymentCreateUpdateParameters;

    DeploymentImpl(DeploymentExtendedInner innerModel, String name, ResourceManager resourceManager) {
        super(name, innerModel);
        this.resourceGroupName = ResourceUtils.groupFromResourceId(innerModel.id());
        this.resourceManager = resourceManager;
        this.deploymentWhatIf = new DeploymentWhatIf();
        this.deploymentCreateUpdateParameters = new DeploymentInner();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String provisioningState() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().provisioningState().toString();
    }

    @Override
    public String correlationId() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().correlationId();
    }

    @Override
    public OffsetDateTime timestamp() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().timestamp();
    }

    @Override
    public Object outputs() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().outputs();
    }

    @Override
    public List<Provider> providers() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (ProviderInner providerInner : ((DeploymentExtendedInner)((Object)this.innerModel())).properties().providers()) {
            providers.add(new ProviderImpl(providerInner));
        }
        return providers;
    }

    @Override
    public List<Dependency> dependencies() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().dependencies();
    }

    @Override
    public String templateHash() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().templateHash();
    }

    @Override
    public TemplateLink templateLink() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().templateLink();
    }

    @Override
    public Object parameters() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().parameters();
    }

    @Override
    public ParametersLink parametersLink() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().parametersLink();
    }

    @Override
    public DeploymentMode mode() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().mode();
    }

    @Override
    public ManagementError error() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().error();
    }

    @Override
    public List<ResourceReference> outputResources() {
        if (((DeploymentExtendedInner)((Object)this.innerModel())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.innerModel())).properties().outputResources();
    }

    @Override
    public DeploymentOperations deploymentOperations() {
        return new DeploymentOperationsImpl(((ResourceManagementClient)this.manager().serviceClient()).getDeploymentOperations(), this);
    }

    @Override
    public void cancel() {
        this.cancelAsync().block();
    }

    @Override
    public Mono<Void> cancelAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().cancelAsync(this.resourceGroupName, this.name());
    }

    @Override
    public DeploymentExportResult exportTemplate() {
        return (DeploymentExportResult)this.exportTemplateAsync().block();
    }

    @Override
    public Mono<DeploymentExportResult> exportTemplateAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().exportTemplateAsync(this.resourceGroupName(), this.name()).map(DeploymentExportResultImpl::new);
    }

    @Override
    public DeploymentImpl prepareWhatIf() {
        return this;
    }

    @Override
    public DeploymentImpl withNewResourceGroup(String resourceGroupName, Region region) {
        this.creatableResourceGroup = (Creatable)((ResourceGroup.DefinitionStages.Blank)this.resourceManager.resourceGroups().define(resourceGroupName)).withRegion(region);
        this.addDependency(this.creatableResourceGroup);
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withNewResourceGroup(Creatable<ResourceGroup> resourceGroupDefinition) {
        this.resourceGroupName = resourceGroupDefinition.name();
        this.addDependency(resourceGroupDefinition);
        this.creatableResourceGroup = resourceGroupDefinition;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroupName = resourceGroup.name();
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(Object template) {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withTemplate(template);
        this.deploymentCreateUpdateParameters.properties().withTemplateLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(String templateJson) throws IOException {
        return this.withTemplate(OBJECT_MAPPER.readTree(templateJson));
    }

    @Override
    public DeploymentImpl withTemplateLink(String uri, String contentVersion) {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withTemplateLink(new TemplateLink().withUri(uri).withContentVersion(contentVersion));
        this.deploymentCreateUpdateParameters.properties().withTemplate(null);
        return this;
    }

    @Override
    public DeploymentImpl withMode(DeploymentMode mode) {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withMode(mode);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(Object parameters) {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withParameters(this.getParametersFromObject(parameters)).withParametersLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(String parametersJson) throws IOException {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withParameters(this.getParametersFromJsonString(parametersJson)).withParametersLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withParametersLink(String uri, String contentVersion) {
        if (this.deploymentCreateUpdateParameters.properties() == null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
        }
        this.deploymentCreateUpdateParameters.properties().withParametersLink(new ParametersLink().withUri(uri).withContentVersion(contentVersion));
        this.deploymentCreateUpdateParameters.properties().withParameters(null);
        return this;
    }

    @Override
    public Accepted<Deployment> beginCreate() {
        return this.beginCreate(Context.NONE);
    }

    @Override
    public Accepted<Deployment> beginCreate(Context context) {
        return AcceptedImpl.newAccepted(this.logger, ((ResourceManagementClient)this.manager().serviceClient()).getHttpPipeline(), ((ResourceManagementClient)this.manager().serviceClient()).getDefaultPollInterval(), () -> (Response)((ResourceManagementClient)this.manager().serviceClient()).getDeployments().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), this.deploymentCreateUpdateParameters).contextWrite(c -> c.putAll(FluxUtil.toReactorContext((Context)context).readOnly())).block(), inner -> new DeploymentImpl((DeploymentExtendedInner)((Object)inner), inner.name(), this.resourceManager), DeploymentExtendedInner.class, () -> {
            if (this.creatableResourceGroup != null) {
                this.creatableResourceGroup.create(context);
            }
        }, inner -> {
            this.setInner(inner);
            this.prepareForUpdate((DeploymentExtendedInner)((Object)inner));
        }, context);
    }

    @Override
    public Mono<Deployment> beginCreateAsync() {
        return Mono.defer(() -> {
            if (this.creatableResourceGroup != null) {
                return this.creatableResourceGroup.createAsync();
            }
            return Mono.just((Object)this);
        }).flatMap(indexable -> ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), this.deploymentCreateUpdateParameters)).flatMap(activationResponse -> FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)activationResponse.getValue()))).map(response -> {
            try {
                return (DeploymentExtendedInner)((Object)((Object)SerializerFactory.createDefaultManagementSerializerAdapter().deserialize(new String((byte[])response, StandardCharsets.UTF_8), DeploymentExtendedInner.class, SerializerEncoding.JSON)));
            }
            catch (IOException ioe) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Failed to deserialize activation response body", ioe));
            }
        }).map(deploymentExtendedInner -> {
            this.prepareForUpdate((DeploymentExtendedInner)((Object)deploymentExtendedInner));
            return deploymentExtendedInner;
        }).map(this.innerToFluentMap(this));
    }

    @Override
    public Mono<Deployment> createResourceAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().createOrUpdateAsync(this.resourceGroupName(), this.name(), this.deploymentCreateUpdateParameters).map(deploymentExtendedInner -> {
            this.prepareForUpdate((DeploymentExtendedInner)((Object)deploymentExtendedInner));
            return deploymentExtendedInner;
        }).map(this.innerToFluentMap(this));
    }

    private void prepareForUpdate(DeploymentExtendedInner inner) {
        this.deploymentCreateUpdateParameters = new DeploymentInner();
        this.deploymentCreateUpdateParameters.withLocation(inner.location());
        this.deploymentCreateUpdateParameters.withTags(inner.tags());
        if (inner.properties() != null) {
            this.deploymentCreateUpdateParameters.withProperties(new DeploymentProperties());
            this.deploymentCreateUpdateParameters.properties().withDebugSetting(inner.properties().debugSetting());
            this.deploymentCreateUpdateParameters.properties().withMode(inner.properties().mode());
            this.deploymentCreateUpdateParameters.properties().withParameters(this.getParametersFromObject(inner.properties().parameters()));
            this.deploymentCreateUpdateParameters.properties().withParametersLink(inner.properties().parametersLink());
            this.deploymentCreateUpdateParameters.properties().withTemplateLink(inner.properties().templateLink());
            if (inner.properties().onErrorDeployment() != null) {
                this.deploymentCreateUpdateParameters.properties().withOnErrorDeployment(new OnErrorDeployment());
                this.deploymentCreateUpdateParameters.properties().onErrorDeployment().withDeploymentName(inner.properties().onErrorDeployment().deploymentName());
                this.deploymentCreateUpdateParameters.properties().onErrorDeployment().withType(inner.properties().onErrorDeployment().type());
            }
        }
    }

    @Override
    public Mono<Deployment> applyAsync() {
        return this.updateResourceAsync();
    }

    @Override
    protected Mono<DeploymentExtendedInner> getInnerAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().getAtManagementGroupScopeAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public boolean isInCreateMode() {
        return ((DeploymentExtendedInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    @Override
    public String id() {
        return ((DeploymentExtendedInner)((Object)this.innerModel())).id();
    }

    @Override
    public DeploymentImpl withDetailedLevel(String detailedLevel) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withDebugSetting(new DebugSetting().withDetailLevel(detailedLevel));
        return this;
    }

    @Override
    public DeploymentImpl withDeploymentName(String deploymentName) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withDeploymentName(deploymentName);
        return this;
    }

    @Override
    public DeploymentImpl withLocation(String location) {
        this.deploymentWhatIf.withLocation(location);
        return this;
    }

    @Override
    public DeploymentImpl withIncrementalMode() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withMode(DeploymentMode.INCREMENTAL);
        return this;
    }

    @Override
    public DeploymentImpl withCompleteMode() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withMode(DeploymentMode.COMPLETE);
        return this;
    }

    @Override
    public DeploymentImpl withFullResourcePayloadsResultFormat() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().whatIfSettings() == null) {
            this.deploymentWhatIf.properties().withWhatIfSettings(new DeploymentWhatIfSettings());
        }
        this.deploymentWhatIf.properties().whatIfSettings().withResultFormat(WhatIfResultFormat.FULL_RESOURCE_PAYLOADS);
        return this;
    }

    @Override
    public DeploymentImpl withResourceIdOnlyResultFormat() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().whatIfSettings() == null) {
            this.deploymentWhatIf.properties().withWhatIfSettings(new DeploymentWhatIfSettings());
        }
        this.deploymentWhatIf.properties().whatIfSettings().withResultFormat(WhatIfResultFormat.RESOURCE_ID_ONLY);
        return this;
    }

    @Override
    public DeploymentImpl withLastSuccessfulOnErrorDeployment() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withType(OnErrorDeploymentType.LAST_SUCCESSFUL);
        return this;
    }

    @Override
    public DeploymentImpl withSpecialDeploymentOnErrorDeployment() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withType(OnErrorDeploymentType.SPECIFIC_DEPLOYMENT);
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfTemplate(Object template) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withTemplate(template);
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfTemplateLink(String uri, String contentVersion) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withTemplateLink(new TemplateLink().withUri(uri).withContentVersion(contentVersion));
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfParameters(Object parameters) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withParameters((Map)this.getParametersFromObject(parameters));
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfParametersLink(String uri, String contentVersion) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withParametersLink(new ParametersLink().withUri(uri).withContentVersion(contentVersion));
        return this;
    }

    @Override
    public WhatIfOperationResult whatIf() {
        return (WhatIfOperationResult)this.whatIfAsync().block();
    }

    @Override
    public Mono<WhatIfOperationResult> whatIfAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().whatIfAsync(this.resourceGroupName(), this.name(), this.deploymentWhatIf).map(WhatIfOperationResultImpl::new);
    }

    @Override
    public WhatIfOperationResult whatIfAtSubscriptionScope() {
        return (WhatIfOperationResult)this.whatIfAtSubscriptionScopeAsync().block();
    }

    @Override
    public Mono<WhatIfOperationResult> whatIfAtSubscriptionScopeAsync() {
        return ((ResourceManagementClient)this.manager().serviceClient()).getDeployments().whatIfAtSubscriptionScopeAsync(this.name(), this.deploymentWhatIf).map(WhatIfOperationResultImpl::new);
    }

    private Map<String, DeploymentParameter> getParametersFromObject(Object parameters) {
        try {
            String parametersJson = SERIALIZER_ADAPTER.serialize(parameters, SerializerEncoding.JSON);
            return this.getParametersFromJsonString(parametersJson);
        }
        catch (IOException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
        }
    }

    private Map<String, DeploymentParameter> getParametersFromJsonString(String parametersJson) throws IOException {
        return (Map)SERIALIZER_ADAPTER.deserialize(parametersJson, TYPE_REFERENCE_MAP_DEPLOYMENT_PARAMETER.getType(), SerializerEncoding.JSON);
    }
}

