/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.resourcemanager.security.models.AlertEntity;
import com.azure.resourcemanager.security.models.AlertPropertiesSupportingEvidence;
import com.azure.resourcemanager.security.models.AlertSeverity;
import com.azure.resourcemanager.security.models.AlertStatus;
import com.azure.resourcemanager.security.models.Intent;
import com.azure.resourcemanager.security.models.ResourceIdentifier;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AlertProperties {
    @JsonProperty(value="version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="alertType", access=JsonProperty.Access.WRITE_ONLY)
    private String alertType;
    @JsonProperty(value="systemAlertId", access=JsonProperty.Access.WRITE_ONLY)
    private String systemAlertId;
    @JsonProperty(value="productComponentName", access=JsonProperty.Access.WRITE_ONLY)
    private String productComponentName;
    @JsonProperty(value="alertDisplayName", access=JsonProperty.Access.WRITE_ONLY)
    private String alertDisplayName;
    @JsonProperty(value="description", access=JsonProperty.Access.WRITE_ONLY)
    private String description;
    @JsonProperty(value="severity", access=JsonProperty.Access.WRITE_ONLY)
    private AlertSeverity severity;
    @JsonProperty(value="intent", access=JsonProperty.Access.WRITE_ONLY)
    private Intent intent;
    @JsonProperty(value="startTimeUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTimeUtc;
    @JsonProperty(value="endTimeUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTimeUtc;
    @JsonProperty(value="resourceIdentifiers", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResourceIdentifier> resourceIdentifiers;
    @JsonProperty(value="remediationSteps", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> remediationSteps;
    @JsonProperty(value="vendorName", access=JsonProperty.Access.WRITE_ONLY)
    private String vendorName;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private AlertStatus status;
    @JsonProperty(value="extendedLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<Map<String, String>> extendedLinks;
    @JsonProperty(value="alertUri", access=JsonProperty.Access.WRITE_ONLY)
    private String alertUri;
    @JsonProperty(value="timeGeneratedUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeGeneratedUtc;
    @JsonProperty(value="productName", access=JsonProperty.Access.WRITE_ONLY)
    private String productName;
    @JsonProperty(value="processingEndTimeUtc", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime processingEndTimeUtc;
    @JsonProperty(value="entities", access=JsonProperty.Access.WRITE_ONLY)
    private List<AlertEntity> entities;
    @JsonProperty(value="isIncident", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean isIncident;
    @JsonProperty(value="correlationKey", access=JsonProperty.Access.WRITE_ONLY)
    private String correlationKey;
    @JsonProperty(value="extendedProperties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> extendedProperties;
    @JsonProperty(value="compromisedEntity", access=JsonProperty.Access.WRITE_ONLY)
    private String compromisedEntity;
    @JsonProperty(value="techniques", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> techniques;
    @JsonProperty(value="subTechniques", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> subTechniques;
    @JsonProperty(value="supportingEvidence")
    private AlertPropertiesSupportingEvidence supportingEvidence;

    public String version() {
        return this.version;
    }

    public String alertType() {
        return this.alertType;
    }

    public String systemAlertId() {
        return this.systemAlertId;
    }

    public String productComponentName() {
        return this.productComponentName;
    }

    public String alertDisplayName() {
        return this.alertDisplayName;
    }

    public String description() {
        return this.description;
    }

    public AlertSeverity severity() {
        return this.severity;
    }

    public Intent intent() {
        return this.intent;
    }

    public OffsetDateTime startTimeUtc() {
        return this.startTimeUtc;
    }

    public OffsetDateTime endTimeUtc() {
        return this.endTimeUtc;
    }

    public List<ResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public List<String> remediationSteps() {
        return this.remediationSteps;
    }

    public String vendorName() {
        return this.vendorName;
    }

    public AlertStatus status() {
        return this.status;
    }

    public List<Map<String, String>> extendedLinks() {
        return this.extendedLinks;
    }

    public String alertUri() {
        return this.alertUri;
    }

    public OffsetDateTime timeGeneratedUtc() {
        return this.timeGeneratedUtc;
    }

    public String productName() {
        return this.productName;
    }

    public OffsetDateTime processingEndTimeUtc() {
        return this.processingEndTimeUtc;
    }

    public List<AlertEntity> entities() {
        return this.entities;
    }

    public Boolean isIncident() {
        return this.isIncident;
    }

    public String correlationKey() {
        return this.correlationKey;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public AlertProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public String compromisedEntity() {
        return this.compromisedEntity;
    }

    public List<String> techniques() {
        return this.techniques;
    }

    public List<String> subTechniques() {
        return this.subTechniques;
    }

    public AlertPropertiesSupportingEvidence supportingEvidence() {
        return this.supportingEvidence;
    }

    public AlertProperties withSupportingEvidence(AlertPropertiesSupportingEvidence supportingEvidence) {
        this.supportingEvidence = supportingEvidence;
        return this;
    }

    public void validate() {
        if (this.resourceIdentifiers() != null) {
            this.resourceIdentifiers().forEach(e -> e.validate());
        }
        if (this.entities() != null) {
            this.entities().forEach(e -> e.validate());
        }
        if (this.supportingEvidence() != null) {
            this.supportingEvidence().validate();
        }
    }
}

