/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.resourcemanager.security.models.EnvironmentDetails;
import com.azure.resourcemanager.security.models.HealthDataClassification;
import com.azure.resourcemanager.security.models.Issue;
import com.azure.resourcemanager.security.models.ResourceDetailsAutoGenerated;
import com.azure.resourcemanager.security.models.StatusAutoGenerated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class HealthReportProperties {
    @JsonProperty(value="resourceDetails")
    private ResourceDetailsAutoGenerated resourceDetails;
    @JsonProperty(value="environmentDetails")
    private EnvironmentDetails environmentDetails;
    @JsonProperty(value="healthDataClassification")
    private HealthDataClassification healthDataClassification;
    @JsonProperty(value="status")
    private StatusAutoGenerated status;
    @JsonProperty(value="affectedDefendersPlans")
    private List<String> affectedDefendersPlans;
    @JsonProperty(value="affectedDefendersSubPlans")
    private List<String> affectedDefendersSubPlans;
    @JsonProperty(value="reportAdditionalData", access=JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> reportAdditionalData;
    @JsonProperty(value="issues")
    private List<Issue> issues;

    public ResourceDetailsAutoGenerated resourceDetails() {
        return this.resourceDetails;
    }

    public HealthReportProperties withResourceDetails(ResourceDetailsAutoGenerated resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    public EnvironmentDetails environmentDetails() {
        return this.environmentDetails;
    }

    public HealthReportProperties withEnvironmentDetails(EnvironmentDetails environmentDetails) {
        this.environmentDetails = environmentDetails;
        return this;
    }

    public HealthDataClassification healthDataClassification() {
        return this.healthDataClassification;
    }

    public HealthReportProperties withHealthDataClassification(HealthDataClassification healthDataClassification) {
        this.healthDataClassification = healthDataClassification;
        return this;
    }

    public StatusAutoGenerated status() {
        return this.status;
    }

    public HealthReportProperties withStatus(StatusAutoGenerated status) {
        this.status = status;
        return this;
    }

    public List<String> affectedDefendersPlans() {
        return this.affectedDefendersPlans;
    }

    public HealthReportProperties withAffectedDefendersPlans(List<String> affectedDefendersPlans) {
        this.affectedDefendersPlans = affectedDefendersPlans;
        return this;
    }

    public List<String> affectedDefendersSubPlans() {
        return this.affectedDefendersSubPlans;
    }

    public HealthReportProperties withAffectedDefendersSubPlans(List<String> affectedDefendersSubPlans) {
        this.affectedDefendersSubPlans = affectedDefendersSubPlans;
        return this;
    }

    public Map<String, String> reportAdditionalData() {
        return this.reportAdditionalData;
    }

    public List<Issue> issues() {
        return this.issues;
    }

    public HealthReportProperties withIssues(List<Issue> issues) {
        this.issues = issues;
        return this;
    }

    public void validate() {
        if (this.resourceDetails() != null) {
            this.resourceDetails().validate();
        }
        if (this.environmentDetails() != null) {
            this.environmentDetails().validate();
        }
        if (this.healthDataClassification() != null) {
            this.healthDataClassification().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
        if (this.issues() != null) {
            this.issues().forEach(e -> e.validate());
        }
    }
}

