/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.security.fluent.models.IoTSecuritySolutionProperties;
import com.azure.resourcemanager.security.models.AdditionalWorkspacesProperties;
import com.azure.resourcemanager.security.models.DataSource;
import com.azure.resourcemanager.security.models.ExportData;
import com.azure.resourcemanager.security.models.RecommendationConfigurationProperties;
import com.azure.resourcemanager.security.models.SecuritySolutionStatus;
import com.azure.resourcemanager.security.models.UnmaskedIpLoggingStatus;
import com.azure.resourcemanager.security.models.UserDefinedResourcesProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class IoTSecuritySolutionModelInner
extends ProxyResource {
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="properties")
    private IoTSecuritySolutionProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;

    public String location() {
        return this.location;
    }

    public IoTSecuritySolutionModelInner withLocation(String location) {
        this.location = location;
        return this;
    }

    private IoTSecuritySolutionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public IoTSecuritySolutionModelInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String workspace() {
        return this.innerProperties() == null ? null : this.innerProperties().workspace();
    }

    public IoTSecuritySolutionModelInner withWorkspace(String workspace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withWorkspace(workspace);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public IoTSecuritySolutionModelInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public SecuritySolutionStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public IoTSecuritySolutionModelInner withStatus(SecuritySolutionStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public List<ExportData> export() {
        return this.innerProperties() == null ? null : this.innerProperties().export();
    }

    public IoTSecuritySolutionModelInner withExport(List<ExportData> export) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withExport(export);
        return this;
    }

    public List<DataSource> disabledDataSources() {
        return this.innerProperties() == null ? null : this.innerProperties().disabledDataSources();
    }

    public IoTSecuritySolutionModelInner withDisabledDataSources(List<DataSource> disabledDataSources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withDisabledDataSources(disabledDataSources);
        return this;
    }

    public List<String> iotHubs() {
        return this.innerProperties() == null ? null : this.innerProperties().iotHubs();
    }

    public IoTSecuritySolutionModelInner withIotHubs(List<String> iotHubs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withIotHubs(iotHubs);
        return this;
    }

    public UserDefinedResourcesProperties userDefinedResources() {
        return this.innerProperties() == null ? null : this.innerProperties().userDefinedResources();
    }

    public IoTSecuritySolutionModelInner withUserDefinedResources(UserDefinedResourcesProperties userDefinedResources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withUserDefinedResources(userDefinedResources);
        return this;
    }

    public List<String> autoDiscoveredResources() {
        return this.innerProperties() == null ? null : this.innerProperties().autoDiscoveredResources();
    }

    public List<RecommendationConfigurationProperties> recommendationsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().recommendationsConfiguration();
    }

    public IoTSecuritySolutionModelInner withRecommendationsConfiguration(List<RecommendationConfigurationProperties> recommendationsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withRecommendationsConfiguration(recommendationsConfiguration);
        return this;
    }

    public UnmaskedIpLoggingStatus unmaskedIpLoggingStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().unmaskedIpLoggingStatus();
    }

    public IoTSecuritySolutionModelInner withUnmaskedIpLoggingStatus(UnmaskedIpLoggingStatus unmaskedIpLoggingStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withUnmaskedIpLoggingStatus(unmaskedIpLoggingStatus);
        return this;
    }

    public List<AdditionalWorkspacesProperties> additionalWorkspaces() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalWorkspaces();
    }

    public IoTSecuritySolutionModelInner withAdditionalWorkspaces(List<AdditionalWorkspacesProperties> additionalWorkspaces) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IoTSecuritySolutionProperties();
        }
        this.innerProperties().withAdditionalWorkspaces(additionalWorkspaces);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

