/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.AdditionalWorkspacesProperties;
import com.azure.resourcemanager.security.models.DataSource;
import com.azure.resourcemanager.security.models.ExportData;
import com.azure.resourcemanager.security.models.RecommendationConfigurationProperties;
import com.azure.resourcemanager.security.models.SecuritySolutionStatus;
import com.azure.resourcemanager.security.models.UnmaskedIpLoggingStatus;
import com.azure.resourcemanager.security.models.UserDefinedResourcesProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class IoTSecuritySolutionProperties {
    @JsonProperty(value="workspace")
    private String workspace;
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="status")
    private SecuritySolutionStatus status;
    @JsonProperty(value="export")
    private List<ExportData> export;
    @JsonProperty(value="disabledDataSources")
    private List<DataSource> disabledDataSources;
    @JsonProperty(value="iotHubs", required=true)
    private List<String> iotHubs;
    @JsonProperty(value="userDefinedResources")
    private UserDefinedResourcesProperties userDefinedResources;
    @JsonProperty(value="autoDiscoveredResources", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> autoDiscoveredResources;
    @JsonProperty(value="recommendationsConfiguration")
    private List<RecommendationConfigurationProperties> recommendationsConfiguration;
    @JsonProperty(value="unmaskedIpLoggingStatus")
    private UnmaskedIpLoggingStatus unmaskedIpLoggingStatus;
    @JsonProperty(value="additionalWorkspaces")
    private List<AdditionalWorkspacesProperties> additionalWorkspaces;
    private static final ClientLogger LOGGER = new ClientLogger(IoTSecuritySolutionProperties.class);

    public String workspace() {
        return this.workspace;
    }

    public IoTSecuritySolutionProperties withWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public IoTSecuritySolutionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public SecuritySolutionStatus status() {
        return this.status;
    }

    public IoTSecuritySolutionProperties withStatus(SecuritySolutionStatus status) {
        this.status = status;
        return this;
    }

    public List<ExportData> export() {
        return this.export;
    }

    public IoTSecuritySolutionProperties withExport(List<ExportData> export) {
        this.export = export;
        return this;
    }

    public List<DataSource> disabledDataSources() {
        return this.disabledDataSources;
    }

    public IoTSecuritySolutionProperties withDisabledDataSources(List<DataSource> disabledDataSources) {
        this.disabledDataSources = disabledDataSources;
        return this;
    }

    public List<String> iotHubs() {
        return this.iotHubs;
    }

    public IoTSecuritySolutionProperties withIotHubs(List<String> iotHubs) {
        this.iotHubs = iotHubs;
        return this;
    }

    public UserDefinedResourcesProperties userDefinedResources() {
        return this.userDefinedResources;
    }

    public IoTSecuritySolutionProperties withUserDefinedResources(UserDefinedResourcesProperties userDefinedResources) {
        this.userDefinedResources = userDefinedResources;
        return this;
    }

    public List<String> autoDiscoveredResources() {
        return this.autoDiscoveredResources;
    }

    public List<RecommendationConfigurationProperties> recommendationsConfiguration() {
        return this.recommendationsConfiguration;
    }

    public IoTSecuritySolutionProperties withRecommendationsConfiguration(List<RecommendationConfigurationProperties> recommendationsConfiguration) {
        this.recommendationsConfiguration = recommendationsConfiguration;
        return this;
    }

    public UnmaskedIpLoggingStatus unmaskedIpLoggingStatus() {
        return this.unmaskedIpLoggingStatus;
    }

    public IoTSecuritySolutionProperties withUnmaskedIpLoggingStatus(UnmaskedIpLoggingStatus unmaskedIpLoggingStatus) {
        this.unmaskedIpLoggingStatus = unmaskedIpLoggingStatus;
        return this;
    }

    public List<AdditionalWorkspacesProperties> additionalWorkspaces() {
        return this.additionalWorkspaces;
    }

    public IoTSecuritySolutionProperties withAdditionalWorkspaces(List<AdditionalWorkspacesProperties> additionalWorkspaces) {
        this.additionalWorkspaces = additionalWorkspaces;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model IoTSecuritySolutionProperties"));
        }
        if (this.iotHubs() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property iotHubs in model IoTSecuritySolutionProperties"));
        }
        if (this.userDefinedResources() != null) {
            this.userDefinedResources().validate();
        }
        if (this.recommendationsConfiguration() != null) {
            this.recommendationsConfiguration().forEach(e -> e.validate());
        }
        if (this.additionalWorkspaces() != null) {
            this.additionalWorkspaces().forEach(e -> e.validate());
        }
    }
}

