/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.Enforce;
import com.azure.resourcemanager.security.models.Extension;
import com.azure.resourcemanager.security.models.Inherited;
import com.azure.resourcemanager.security.models.PricingTier;
import com.azure.resourcemanager.security.models.ResourcesCoverageStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

public final class PricingProperties {
    @JsonProperty(value="pricingTier", required=true)
    private PricingTier pricingTier;
    @JsonProperty(value="subPlan")
    private String subPlan;
    @JsonProperty(value="freeTrialRemainingTime", access=JsonProperty.Access.WRITE_ONLY)
    private Duration freeTrialRemainingTime;
    @JsonProperty(value="enablementTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime enablementTime;
    @JsonProperty(value="enforce")
    private Enforce enforce;
    @JsonProperty(value="inherited", access=JsonProperty.Access.WRITE_ONLY)
    private Inherited inherited;
    @JsonProperty(value="inheritedFrom", access=JsonProperty.Access.WRITE_ONLY)
    private String inheritedFrom;
    @JsonProperty(value="resourcesCoverageStatus", access=JsonProperty.Access.WRITE_ONLY)
    private ResourcesCoverageStatus resourcesCoverageStatus;
    @JsonProperty(value="extensions")
    private List<Extension> extensions;
    @JsonProperty(value="deprecated", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean deprecated;
    @JsonProperty(value="replacedBy", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> replacedBy;
    private static final ClientLogger LOGGER = new ClientLogger(PricingProperties.class);

    public PricingTier pricingTier() {
        return this.pricingTier;
    }

    public PricingProperties withPricingTier(PricingTier pricingTier) {
        this.pricingTier = pricingTier;
        return this;
    }

    public String subPlan() {
        return this.subPlan;
    }

    public PricingProperties withSubPlan(String subPlan) {
        this.subPlan = subPlan;
        return this;
    }

    public Duration freeTrialRemainingTime() {
        return this.freeTrialRemainingTime;
    }

    public OffsetDateTime enablementTime() {
        return this.enablementTime;
    }

    public Enforce enforce() {
        return this.enforce;
    }

    public PricingProperties withEnforce(Enforce enforce) {
        this.enforce = enforce;
        return this;
    }

    public Inherited inherited() {
        return this.inherited;
    }

    public String inheritedFrom() {
        return this.inheritedFrom;
    }

    public ResourcesCoverageStatus resourcesCoverageStatus() {
        return this.resourcesCoverageStatus;
    }

    public List<Extension> extensions() {
        return this.extensions;
    }

    public PricingProperties withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public List<String> replacedBy() {
        return this.replacedBy;
    }

    public void validate() {
        if (this.pricingTier() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property pricingTier in model PricingProperties"));
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }
}

