/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.models.AssessmentType;
import com.azure.resourcemanager.security.models.Categories;
import com.azure.resourcemanager.security.models.ImplementationEffort;
import com.azure.resourcemanager.security.models.SecurityAssessmentMetadataPartnerData;
import com.azure.resourcemanager.security.models.Severity;
import com.azure.resourcemanager.security.models.Threats;
import com.azure.resourcemanager.security.models.UserImpact;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class SecurityAssessmentMetadataProperties {
    @JsonProperty(value="displayName", required=true)
    private String displayName;
    @JsonProperty(value="policyDefinitionId", access=JsonProperty.Access.WRITE_ONLY)
    private String policyDefinitionId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="remediationDescription")
    private String remediationDescription;
    @JsonProperty(value="categories")
    private List<Categories> categories;
    @JsonProperty(value="severity", required=true)
    private Severity severity;
    @JsonProperty(value="userImpact")
    private UserImpact userImpact;
    @JsonProperty(value="implementationEffort")
    private ImplementationEffort implementationEffort;
    @JsonProperty(value="threats")
    private List<Threats> threats;
    @JsonProperty(value="preview")
    private Boolean preview;
    @JsonProperty(value="assessmentType", required=true)
    private AssessmentType assessmentType;
    @JsonProperty(value="partnerData")
    private SecurityAssessmentMetadataPartnerData partnerData;
    private static final ClientLogger LOGGER = new ClientLogger(SecurityAssessmentMetadataProperties.class);

    public String displayName() {
        return this.displayName;
    }

    public SecurityAssessmentMetadataProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    public String description() {
        return this.description;
    }

    public SecurityAssessmentMetadataProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String remediationDescription() {
        return this.remediationDescription;
    }

    public SecurityAssessmentMetadataProperties withRemediationDescription(String remediationDescription) {
        this.remediationDescription = remediationDescription;
        return this;
    }

    public List<Categories> categories() {
        return this.categories;
    }

    public SecurityAssessmentMetadataProperties withCategories(List<Categories> categories) {
        this.categories = categories;
        return this;
    }

    public Severity severity() {
        return this.severity;
    }

    public SecurityAssessmentMetadataProperties withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public UserImpact userImpact() {
        return this.userImpact;
    }

    public SecurityAssessmentMetadataProperties withUserImpact(UserImpact userImpact) {
        this.userImpact = userImpact;
        return this;
    }

    public ImplementationEffort implementationEffort() {
        return this.implementationEffort;
    }

    public SecurityAssessmentMetadataProperties withImplementationEffort(ImplementationEffort implementationEffort) {
        this.implementationEffort = implementationEffort;
        return this;
    }

    public List<Threats> threats() {
        return this.threats;
    }

    public SecurityAssessmentMetadataProperties withThreats(List<Threats> threats) {
        this.threats = threats;
        return this;
    }

    public Boolean preview() {
        return this.preview;
    }

    public SecurityAssessmentMetadataProperties withPreview(Boolean preview) {
        this.preview = preview;
        return this;
    }

    public AssessmentType assessmentType() {
        return this.assessmentType;
    }

    public SecurityAssessmentMetadataProperties withAssessmentType(AssessmentType assessmentType) {
        this.assessmentType = assessmentType;
        return this;
    }

    public SecurityAssessmentMetadataPartnerData partnerData() {
        return this.partnerData;
    }

    public SecurityAssessmentMetadataProperties withPartnerData(SecurityAssessmentMetadataPartnerData partnerData) {
        this.partnerData = partnerData;
        return this;
    }

    public void validate() {
        if (this.displayName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property displayName in model SecurityAssessmentMetadataProperties"));
        }
        if (this.severity() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property severity in model SecurityAssessmentMetadataProperties"));
        }
        if (this.assessmentType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property assessmentType in model SecurityAssessmentMetadataProperties"));
        }
        if (this.partnerData() != null) {
            this.partnerData().validate();
        }
    }
}

