/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.fluent.models;

import com.azure.resourcemanager.security.models.CloudName;
import com.azure.resourcemanager.security.models.CloudOffering;
import com.azure.resourcemanager.security.models.EnvironmentData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class SecurityConnectorProperties {
    @JsonProperty(value="hierarchyIdentifier")
    private String hierarchyIdentifier;
    @JsonProperty(value="hierarchyIdentifierTrialEndDate", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime hierarchyIdentifierTrialEndDate;
    @JsonProperty(value="environmentName")
    private CloudName environmentName;
    @JsonProperty(value="offerings")
    private List<CloudOffering> offerings;
    @JsonProperty(value="environmentData")
    private EnvironmentData environmentData;

    public String hierarchyIdentifier() {
        return this.hierarchyIdentifier;
    }

    public SecurityConnectorProperties withHierarchyIdentifier(String hierarchyIdentifier) {
        this.hierarchyIdentifier = hierarchyIdentifier;
        return this;
    }

    public OffsetDateTime hierarchyIdentifierTrialEndDate() {
        return this.hierarchyIdentifierTrialEndDate;
    }

    public CloudName environmentName() {
        return this.environmentName;
    }

    public SecurityConnectorProperties withEnvironmentName(CloudName environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public List<CloudOffering> offerings() {
        return this.offerings;
    }

    public SecurityConnectorProperties withOfferings(List<CloudOffering> offerings) {
        this.offerings = offerings;
        return this;
    }

    public EnvironmentData environmentData() {
        return this.environmentData;
    }

    public SecurityConnectorProperties withEnvironmentData(EnvironmentData environmentData) {
        this.environmentData = environmentData;
        return this;
    }

    public void validate() {
        if (this.offerings() != null) {
            this.offerings().forEach(e -> e.validate());
        }
        if (this.environmentData() != null) {
            this.environmentData().validate();
        }
    }
}

