/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlGroup;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlIssueSummary;
import com.azure.resourcemanager.security.models.ConfigurationStatus;
import com.azure.resourcemanager.security.models.EnforcementMode;
import com.azure.resourcemanager.security.models.PathRecommendation;
import com.azure.resourcemanager.security.models.ProtectionMode;
import com.azure.resourcemanager.security.models.RecommendationStatus;
import com.azure.resourcemanager.security.models.SourceSystem;
import com.azure.resourcemanager.security.models.VmRecommendation;
import java.util.Collections;
import java.util.List;

public final class AdaptiveApplicationControlGroupImpl
implements AdaptiveApplicationControlGroup,
AdaptiveApplicationControlGroup.Definition,
AdaptiveApplicationControlGroup.Update {
    private AdaptiveApplicationControlGroupInner innerObject;
    private final SecurityManager serviceManager;
    private String ascLocation;
    private String groupName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public EnforcementMode enforcementMode() {
        return this.innerModel().enforcementMode();
    }

    @Override
    public ProtectionMode protectionMode() {
        return this.innerModel().protectionMode();
    }

    @Override
    public ConfigurationStatus configurationStatus() {
        return this.innerModel().configurationStatus();
    }

    @Override
    public RecommendationStatus recommendationStatus() {
        return this.innerModel().recommendationStatus();
    }

    @Override
    public List<AdaptiveApplicationControlIssueSummary> issues() {
        List<AdaptiveApplicationControlIssueSummary> inner = this.innerModel().issues();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SourceSystem sourceSystem() {
        return this.innerModel().sourceSystem();
    }

    @Override
    public List<VmRecommendation> vmRecommendations() {
        List<VmRecommendation> inner = this.innerModel().vmRecommendations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<PathRecommendation> pathRecommendations() {
        List<PathRecommendation> inner = this.innerModel().pathRecommendations();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public AdaptiveApplicationControlGroupInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl withExistingLocation(String ascLocation) {
        this.ascLocation = ascLocation;
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroup create() {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().putWithResponse(this.ascLocation, this.groupName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroup create(Context context) {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().putWithResponse(this.ascLocation, this.groupName, this.innerModel(), context).getValue());
        return this;
    }

    AdaptiveApplicationControlGroupImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new AdaptiveApplicationControlGroupInner();
        this.serviceManager = serviceManager;
        this.groupName = name;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl update() {
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroup apply() {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().putWithResponse(this.ascLocation, this.groupName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroup apply(Context context) {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().putWithResponse(this.ascLocation, this.groupName, this.innerModel(), context).getValue());
        return this;
    }

    AdaptiveApplicationControlGroupImpl(AdaptiveApplicationControlGroupInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.ascLocation = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "locations");
        this.groupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "applicationWhitelistings");
    }

    @Override
    public AdaptiveApplicationControlGroup refresh() {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().getWithResponse(this.ascLocation, this.groupName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroup refresh(Context context) {
        this.innerObject = (AdaptiveApplicationControlGroupInner)((Object)this.serviceManager.serviceClient().getAdaptiveApplicationControls().getWithResponse(this.ascLocation, this.groupName, context).getValue());
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl withEnforcementMode(EnforcementMode enforcementMode) {
        this.innerModel().withEnforcementMode(enforcementMode);
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl withProtectionMode(ProtectionMode protectionMode) {
        this.innerModel().withProtectionMode(protectionMode);
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl withVmRecommendations(List<VmRecommendation> vmRecommendations) {
        this.innerModel().withVmRecommendations(vmRecommendations);
        return this;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl withPathRecommendations(List<PathRecommendation> pathRecommendations) {
        this.innerModel().withPathRecommendations(pathRecommendations);
        return this;
    }
}

