/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AdaptiveApplicationControlsClient;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupInner;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupsInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class AdaptiveApplicationControlsClientImpl
implements AdaptiveApplicationControlsClient {
    private final AdaptiveApplicationControlsService service;
    private final SecurityCenterImpl client;

    AdaptiveApplicationControlsClientImpl(SecurityCenterImpl client) {
        this.service = (AdaptiveApplicationControlsService)RestProxy.create(AdaptiveApplicationControlsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupsInner>> listWithResponseAsync(Boolean includePathRecommendations, Boolean summary) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-01-01", includePathRecommendations, summary, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupsInner>> listWithResponseAsync(Boolean includePathRecommendations, Boolean summary, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), "2020-01-01", includePathRecommendations, summary, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdaptiveApplicationControlGroupsInner> listAsync() {
        Boolean includePathRecommendations = null;
        Boolean summary = null;
        return this.listWithResponseAsync(includePathRecommendations, summary).flatMap(res -> Mono.justOrEmpty((Object)((AdaptiveApplicationControlGroupsInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdaptiveApplicationControlGroupsInner> listWithResponse(Boolean includePathRecommendations, Boolean summary, Context context) {
        return (Response)this.listWithResponseAsync(includePathRecommendations, summary, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdaptiveApplicationControlGroupsInner list() {
        Boolean includePathRecommendations = null;
        Boolean summary = null;
        return (AdaptiveApplicationControlGroupsInner)this.listWithResponse(includePathRecommendations, summary, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupInner>> getWithResponseAsync(String ascLocation, String groupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupInner>> getWithResponseAsync(String ascLocation, String groupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdaptiveApplicationControlGroupInner> getAsync(String ascLocation, String groupName) {
        return this.getWithResponseAsync(ascLocation, groupName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AdaptiveApplicationControlGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdaptiveApplicationControlGroupInner> getWithResponse(String ascLocation, String groupName, Context context) {
        return (Response)this.getWithResponseAsync(ascLocation, groupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdaptiveApplicationControlGroupInner get(String ascLocation, String groupName) {
        return (AdaptiveApplicationControlGroupInner)((Object)this.getWithResponse(ascLocation, groupName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupInner>> putWithResponseAsync(String ascLocation, String groupName, AdaptiveApplicationControlGroupInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdaptiveApplicationControlGroupInner>> putWithResponseAsync(String ascLocation, String groupName, AdaptiveApplicationControlGroupInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.put(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdaptiveApplicationControlGroupInner> putAsync(String ascLocation, String groupName, AdaptiveApplicationControlGroupInner body) {
        return this.putWithResponseAsync(ascLocation, groupName, body).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AdaptiveApplicationControlGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdaptiveApplicationControlGroupInner> putWithResponse(String ascLocation, String groupName, AdaptiveApplicationControlGroupInner body, Context context) {
        return (Response)this.putWithResponseAsync(ascLocation, groupName, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdaptiveApplicationControlGroupInner put(String ascLocation, String groupName, AdaptiveApplicationControlGroupInner body) {
        return (AdaptiveApplicationControlGroupInner)((Object)this.putWithResponse(ascLocation, groupName, body, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String ascLocation, String groupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String ascLocation, String groupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (ascLocation == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter ascLocation is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        String apiVersion = "2020-01-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), ascLocation, groupName, "2020-01-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String ascLocation, String groupName) {
        return this.deleteWithResponseAsync(ascLocation, groupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String ascLocation, String groupName, Context context) {
        return (Response)this.deleteWithResponseAsync(ascLocation, groupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String ascLocation, String groupName) {
        this.deleteWithResponse(ascLocation, groupName, Context.NONE);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAdapti")
    public static interface AdaptiveApplicationControlsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/applicationWhitelistings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveApplicationControlGroupsInner>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="includePathRecommendations") Boolean var4, @QueryParam(value="summary") Boolean var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/applicationWhitelistings/{groupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveApplicationControlGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="ascLocation") String var3, @PathParam(value="groupName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/applicationWhitelistings/{groupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdaptiveApplicationControlGroupInner>> put(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="ascLocation") String var3, @PathParam(value="groupName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") AdaptiveApplicationControlGroupInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/applicationWhitelistings/{groupName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="ascLocation") String var3, @PathParam(value="groupName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

