/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AdaptiveApplicationControlsClient;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupInner;
import com.azure.resourcemanager.security.fluent.models.AdaptiveApplicationControlGroupsInner;
import com.azure.resourcemanager.security.implementation.AdaptiveApplicationControlGroupImpl;
import com.azure.resourcemanager.security.implementation.AdaptiveApplicationControlGroupsImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlGroup;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControlGroups;
import com.azure.resourcemanager.security.models.AdaptiveApplicationControls;

public final class AdaptiveApplicationControlsImpl
implements AdaptiveApplicationControls {
    private static final ClientLogger LOGGER = new ClientLogger(AdaptiveApplicationControlsImpl.class);
    private final AdaptiveApplicationControlsClient innerClient;
    private final SecurityManager serviceManager;

    public AdaptiveApplicationControlsImpl(AdaptiveApplicationControlsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AdaptiveApplicationControlGroups> listWithResponse(Boolean includePathRecommendations, Boolean summary, Context context) {
        Response<AdaptiveApplicationControlGroupsInner> inner = this.serviceClient().listWithResponse(includePathRecommendations, summary, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdaptiveApplicationControlGroupsImpl((AdaptiveApplicationControlGroupsInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AdaptiveApplicationControlGroups list() {
        AdaptiveApplicationControlGroupsInner inner = this.serviceClient().list();
        if (inner != null) {
            return new AdaptiveApplicationControlGroupsImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AdaptiveApplicationControlGroup> getWithResponse(String ascLocation, String groupName, Context context) {
        Response<AdaptiveApplicationControlGroupInner> inner = this.serviceClient().getWithResponse(ascLocation, groupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdaptiveApplicationControlGroupImpl((AdaptiveApplicationControlGroupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AdaptiveApplicationControlGroup get(String ascLocation, String groupName) {
        AdaptiveApplicationControlGroupInner inner = this.serviceClient().get(ascLocation, groupName);
        if (inner != null) {
            return new AdaptiveApplicationControlGroupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String ascLocation, String groupName, Context context) {
        return this.serviceClient().deleteWithResponse(ascLocation, groupName, context);
    }

    @Override
    public void deleteByResourceGroup(String ascLocation, String groupName) {
        this.serviceClient().delete(ascLocation, groupName);
    }

    @Override
    public AdaptiveApplicationControlGroup getById(String id) {
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "applicationWhitelistings");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationWhitelistings'.", id)));
        }
        return (AdaptiveApplicationControlGroup)this.getWithResponse(ascLocation, groupName, Context.NONE).getValue();
    }

    @Override
    public Response<AdaptiveApplicationControlGroup> getByIdWithResponse(String id, Context context) {
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "applicationWhitelistings");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationWhitelistings'.", id)));
        }
        return this.getWithResponse(ascLocation, groupName, context);
    }

    @Override
    public void deleteById(String id) {
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "applicationWhitelistings");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationWhitelistings'.", id)));
        }
        this.deleteByResourceGroupWithResponse(ascLocation, groupName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String ascLocation = ResourceManagerUtils.getValueFromIdByName(id, "locations");
        if (ascLocation == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'locations'.", id)));
        }
        String groupName = ResourceManagerUtils.getValueFromIdByName(id, "applicationWhitelistings");
        if (groupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applicationWhitelistings'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(ascLocation, groupName, context);
    }

    private AdaptiveApplicationControlsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AdaptiveApplicationControlGroupImpl define(String name) {
        return new AdaptiveApplicationControlGroupImpl(name, this.manager());
    }
}

