/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AdvancedThreatProtectionsClient;
import com.azure.resourcemanager.security.fluent.models.AdvancedThreatProtectionSettingInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import reactor.core.publisher.Mono;

public final class AdvancedThreatProtectionsClientImpl
implements AdvancedThreatProtectionsClient {
    private final AdvancedThreatProtectionsService service;
    private final SecurityCenterImpl client;

    AdvancedThreatProtectionsClientImpl(SecurityCenterImpl client) {
        this.service = (AdvancedThreatProtectionsService)RestProxy.create(AdvancedThreatProtectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdvancedThreatProtectionSettingInner>> getWithResponseAsync(String resourceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-01-01";
        String settingName = "current";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-01-01", resourceId, "current", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdvancedThreatProtectionSettingInner>> getWithResponseAsync(String resourceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        String apiVersion = "2019-01-01";
        String settingName = "current";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-01-01", resourceId, "current", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdvancedThreatProtectionSettingInner> getAsync(String resourceId) {
        return this.getWithResponseAsync(resourceId).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AdvancedThreatProtectionSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdvancedThreatProtectionSettingInner> getWithResponse(String resourceId, Context context) {
        return (Response)this.getWithResponseAsync(resourceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdvancedThreatProtectionSettingInner get(String resourceId) {
        return (AdvancedThreatProtectionSettingInner)((Object)this.getWithResponse(resourceId, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdvancedThreatProtectionSettingInner>> createWithResponseAsync(String resourceId, AdvancedThreatProtectionSettingInner advancedThreatProtectionSetting) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (advancedThreatProtectionSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter advancedThreatProtectionSetting is required and cannot be null."));
        }
        advancedThreatProtectionSetting.validate();
        String apiVersion = "2019-01-01";
        String settingName = "current";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2019-01-01", resourceId, "current", advancedThreatProtectionSetting, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AdvancedThreatProtectionSettingInner>> createWithResponseAsync(String resourceId, AdvancedThreatProtectionSettingInner advancedThreatProtectionSetting, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceId is required and cannot be null."));
        }
        if (advancedThreatProtectionSetting == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter advancedThreatProtectionSetting is required and cannot be null."));
        }
        advancedThreatProtectionSetting.validate();
        String apiVersion = "2019-01-01";
        String settingName = "current";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), "2019-01-01", resourceId, "current", advancedThreatProtectionSetting, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AdvancedThreatProtectionSettingInner> createAsync(String resourceId, AdvancedThreatProtectionSettingInner advancedThreatProtectionSetting) {
        return this.createWithResponseAsync(resourceId, advancedThreatProtectionSetting).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AdvancedThreatProtectionSettingInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AdvancedThreatProtectionSettingInner> createWithResponse(String resourceId, AdvancedThreatProtectionSettingInner advancedThreatProtectionSetting, Context context) {
        return (Response)this.createWithResponseAsync(resourceId, advancedThreatProtectionSetting, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AdvancedThreatProtectionSettingInner create(String resourceId, AdvancedThreatProtectionSettingInner advancedThreatProtectionSetting) {
        return (AdvancedThreatProtectionSettingInner)((Object)this.createWithResponse(resourceId, advancedThreatProtectionSetting, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAdvanc")
    public static interface AdvancedThreatProtectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdvancedThreatProtectionSettingInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="settingName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AdvancedThreatProtectionSettingInner>> create(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceId", encoded=true) String var3, @PathParam(value="settingName") String var4, @BodyParam(value="application/json") AdvancedThreatProtectionSettingInner var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

