/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AdvancedThreatProtectionsClient;
import com.azure.resourcemanager.security.fluent.models.AdvancedThreatProtectionSettingInner;
import com.azure.resourcemanager.security.implementation.AdvancedThreatProtectionSettingImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AdvancedThreatProtectionSetting;
import com.azure.resourcemanager.security.models.AdvancedThreatProtections;

public final class AdvancedThreatProtectionsImpl
implements AdvancedThreatProtections {
    private static final ClientLogger LOGGER = new ClientLogger(AdvancedThreatProtectionsImpl.class);
    private final AdvancedThreatProtectionsClient innerClient;
    private final SecurityManager serviceManager;

    public AdvancedThreatProtectionsImpl(AdvancedThreatProtectionsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AdvancedThreatProtectionSetting> getWithResponse(String resourceId, Context context) {
        Response<AdvancedThreatProtectionSettingInner> inner = this.serviceClient().getWithResponse(resourceId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AdvancedThreatProtectionSettingImpl((AdvancedThreatProtectionSettingInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AdvancedThreatProtectionSetting get(String resourceId) {
        AdvancedThreatProtectionSettingInner inner = this.serviceClient().get(resourceId);
        if (inner != null) {
            return new AdvancedThreatProtectionSettingImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public AdvancedThreatProtectionSetting getById(String id) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        return (AdvancedThreatProtectionSetting)this.getWithResponse(resourceId, Context.NONE).getValue();
    }

    @Override
    public Response<AdvancedThreatProtectionSetting> getByIdWithResponse(String id, Context context) {
        String resourceId = ResourceManagerUtils.getValueFromIdByParameterName(id, "/{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}", "resourceId");
        if (resourceId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceId'.", id)));
        }
        return this.getWithResponse(resourceId, context);
    }

    private AdvancedThreatProtectionsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public AdvancedThreatProtectionSettingImpl define() {
        return new AdvancedThreatProtectionSettingImpl(this.manager());
    }
}

