/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AlertsClient;
import com.azure.resourcemanager.security.fluent.models.AlertInner;
import com.azure.resourcemanager.security.implementation.AlertImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Alert;
import com.azure.resourcemanager.security.models.AlertSimulatorRequestBody;
import com.azure.resourcemanager.security.models.Alerts;

public final class AlertsImpl
implements Alerts {
    private static final ClientLogger LOGGER = new ClientLogger(AlertsImpl.class);
    private final AlertsClient innerClient;
    private final SecurityManager serviceManager;

    public AlertsImpl(AlertsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Alert> list() {
        PagedIterable<AlertInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> list(Context context) {
        PagedIterable<AlertInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listByResourceGroup(String resourceGroupName) {
        PagedIterable<AlertInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<AlertInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listSubscriptionLevelByRegion(String ascLocation) {
        PagedIterable<AlertInner> inner = this.serviceClient().listSubscriptionLevelByRegion(ascLocation);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listSubscriptionLevelByRegion(String ascLocation, Context context) {
        PagedIterable<AlertInner> inner = this.serviceClient().listSubscriptionLevelByRegion(ascLocation, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listResourceGroupLevelByRegion(String ascLocation, String resourceGroupName) {
        PagedIterable<AlertInner> inner = this.serviceClient().listResourceGroupLevelByRegion(ascLocation, resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Alert> listResourceGroupLevelByRegion(String ascLocation, String resourceGroupName, Context context) {
        PagedIterable<AlertInner> inner = this.serviceClient().listResourceGroupLevelByRegion(ascLocation, resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertImpl((AlertInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Alert> getSubscriptionLevelWithResponse(String ascLocation, String alertName, Context context) {
        Response<AlertInner> inner = this.serviceClient().getSubscriptionLevelWithResponse(ascLocation, alertName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertImpl((AlertInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Alert getSubscriptionLevel(String ascLocation, String alertName) {
        AlertInner inner = this.serviceClient().getSubscriptionLevel(ascLocation, alertName);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Alert> getResourceGroupLevelWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        Response<AlertInner> inner = this.serviceClient().getResourceGroupLevelWithResponse(resourceGroupName, ascLocation, alertName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertImpl((AlertInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Alert getResourceGroupLevel(String resourceGroupName, String ascLocation, String alertName) {
        AlertInner inner = this.serviceClient().getResourceGroupLevel(resourceGroupName, ascLocation, alertName);
        if (inner != null) {
            return new AlertImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> updateSubscriptionLevelStateToDismissWithResponse(String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateSubscriptionLevelStateToDismissWithResponse(ascLocation, alertName, context);
    }

    @Override
    public void updateSubscriptionLevelStateToDismiss(String ascLocation, String alertName) {
        this.serviceClient().updateSubscriptionLevelStateToDismiss(ascLocation, alertName);
    }

    @Override
    public Response<Void> updateSubscriptionLevelStateToResolveWithResponse(String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateSubscriptionLevelStateToResolveWithResponse(ascLocation, alertName, context);
    }

    @Override
    public void updateSubscriptionLevelStateToResolve(String ascLocation, String alertName) {
        this.serviceClient().updateSubscriptionLevelStateToResolve(ascLocation, alertName);
    }

    @Override
    public Response<Void> updateSubscriptionLevelStateToActivateWithResponse(String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateSubscriptionLevelStateToActivateWithResponse(ascLocation, alertName, context);
    }

    @Override
    public void updateSubscriptionLevelStateToActivate(String ascLocation, String alertName) {
        this.serviceClient().updateSubscriptionLevelStateToActivate(ascLocation, alertName);
    }

    @Override
    public Response<Void> updateSubscriptionLevelStateToInProgressWithResponse(String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateSubscriptionLevelStateToInProgressWithResponse(ascLocation, alertName, context);
    }

    @Override
    public void updateSubscriptionLevelStateToInProgress(String ascLocation, String alertName) {
        this.serviceClient().updateSubscriptionLevelStateToInProgress(ascLocation, alertName);
    }

    @Override
    public Response<Void> updateResourceGroupLevelStateToResolveWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateResourceGroupLevelStateToResolveWithResponse(resourceGroupName, ascLocation, alertName, context);
    }

    @Override
    public void updateResourceGroupLevelStateToResolve(String resourceGroupName, String ascLocation, String alertName) {
        this.serviceClient().updateResourceGroupLevelStateToResolve(resourceGroupName, ascLocation, alertName);
    }

    @Override
    public Response<Void> updateResourceGroupLevelStateToDismissWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateResourceGroupLevelStateToDismissWithResponse(resourceGroupName, ascLocation, alertName, context);
    }

    @Override
    public void updateResourceGroupLevelStateToDismiss(String resourceGroupName, String ascLocation, String alertName) {
        this.serviceClient().updateResourceGroupLevelStateToDismiss(resourceGroupName, ascLocation, alertName);
    }

    @Override
    public Response<Void> updateResourceGroupLevelStateToActivateWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateResourceGroupLevelStateToActivateWithResponse(resourceGroupName, ascLocation, alertName, context);
    }

    @Override
    public void updateResourceGroupLevelStateToActivate(String resourceGroupName, String ascLocation, String alertName) {
        this.serviceClient().updateResourceGroupLevelStateToActivate(resourceGroupName, ascLocation, alertName);
    }

    @Override
    public Response<Void> updateResourceGroupLevelStateToInProgressWithResponse(String resourceGroupName, String ascLocation, String alertName, Context context) {
        return this.serviceClient().updateResourceGroupLevelStateToInProgressWithResponse(resourceGroupName, ascLocation, alertName, context);
    }

    @Override
    public void updateResourceGroupLevelStateToInProgress(String resourceGroupName, String ascLocation, String alertName) {
        this.serviceClient().updateResourceGroupLevelStateToInProgress(resourceGroupName, ascLocation, alertName);
    }

    @Override
    public void simulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody) {
        this.serviceClient().simulate(ascLocation, alertSimulatorRequestBody);
    }

    @Override
    public void simulate(String ascLocation, AlertSimulatorRequestBody alertSimulatorRequestBody, Context context) {
        this.serviceClient().simulate(ascLocation, alertSimulatorRequestBody, context);
    }

    private AlertsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

