/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.security.fluent.AlertsSuppressionRulesClient;
import com.azure.resourcemanager.security.fluent.models.AlertsSuppressionRuleInner;
import com.azure.resourcemanager.security.implementation.SecurityCenterImpl;
import com.azure.resourcemanager.security.models.AlertsSuppressionRulesList;
import reactor.core.publisher.Mono;

public final class AlertsSuppressionRulesClientImpl
implements AlertsSuppressionRulesClient {
    private final AlertsSuppressionRulesService service;
    private final SecurityCenterImpl client;

    AlertsSuppressionRulesClientImpl(SecurityCenterImpl client) {
        this.service = (AlertsSuppressionRulesService)RestProxy.create(AlertsSuppressionRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertsSuppressionRuleInner>> listSinglePageAsync(String alertType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertType, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertsSuppressionRulesList)res.getValue()).value(), ((AlertsSuppressionRulesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertsSuppressionRuleInner>> listSinglePageAsync(String alertType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertType, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertsSuppressionRulesList)res.getValue()).value(), ((AlertsSuppressionRulesList)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertsSuppressionRuleInner> listAsync(String alertType) {
        return new PagedFlux(() -> this.listSinglePageAsync(alertType), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertsSuppressionRuleInner> listAsync() {
        String alertType = null;
        return new PagedFlux(() -> this.listSinglePageAsync(alertType), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AlertsSuppressionRuleInner> listAsync(String alertType, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(alertType, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertsSuppressionRuleInner> list() {
        String alertType = null;
        return new PagedIterable(this.listAsync(alertType));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AlertsSuppressionRuleInner> list(String alertType, Context context) {
        return new PagedIterable(this.listAsync(alertType, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsSuppressionRuleInner>> getWithResponseAsync(String alertsSuppressionRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsSuppressionRuleInner>> getWithResponseAsync(String alertsSuppressionRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertsSuppressionRuleInner> getAsync(String alertsSuppressionRuleName) {
        return this.getWithResponseAsync(alertsSuppressionRuleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertsSuppressionRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertsSuppressionRuleInner> getWithResponse(String alertsSuppressionRuleName, Context context) {
        return (Response)this.getWithResponseAsync(alertsSuppressionRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertsSuppressionRuleInner get(String alertsSuppressionRuleName) {
        return (AlertsSuppressionRuleInner)((Object)this.getWithResponse(alertsSuppressionRuleName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsSuppressionRuleInner>> updateWithResponseAsync(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        if (alertsSuppressionRule == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRule is required and cannot be null."));
        }
        alertsSuppressionRule.validate();
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, alertsSuppressionRule, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AlertsSuppressionRuleInner>> updateWithResponseAsync(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        if (alertsSuppressionRule == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRule is required and cannot be null."));
        }
        alertsSuppressionRule.validate();
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, alertsSuppressionRule, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AlertsSuppressionRuleInner> updateAsync(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule) {
        return this.updateWithResponseAsync(alertsSuppressionRuleName, alertsSuppressionRule).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AlertsSuppressionRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AlertsSuppressionRuleInner> updateWithResponse(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule, Context context) {
        return (Response)this.updateWithResponseAsync(alertsSuppressionRuleName, alertsSuppressionRule, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AlertsSuppressionRuleInner update(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule) {
        return (AlertsSuppressionRuleInner)((Object)this.updateWithResponse(alertsSuppressionRuleName, alertsSuppressionRule, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String alertsSuppressionRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String alertsSuppressionRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (alertsSuppressionRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter alertsSuppressionRuleName is required and cannot be null."));
        }
        String apiVersion = "2019-01-01-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2019-01-01-preview", this.client.getSubscriptionId(), alertsSuppressionRuleName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String alertsSuppressionRuleName) {
        return this.deleteWithResponseAsync(alertsSuppressionRuleName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String alertsSuppressionRuleName, Context context) {
        return (Response)this.deleteWithResponseAsync(alertsSuppressionRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String alertsSuppressionRuleName) {
        this.deleteWithResponse(alertsSuppressionRuleName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertsSuppressionRuleInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertsSuppressionRulesList)res.getValue()).value(), ((AlertsSuppressionRulesList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AlertsSuppressionRuleInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AlertsSuppressionRulesList)res.getValue()).value(), ((AlertsSuppressionRulesList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SecurityCenterAlerts")
    public static interface AlertsSuppressionRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsSuppressionRulesList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="AlertType") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsSuppressionRuleInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="alertsSuppressionRuleName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsSuppressionRuleInner>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="alertsSuppressionRuleName") String var4, @BodyParam(value="application/json") AlertsSuppressionRuleInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/providers/Microsoft.Security/alertsSuppressionRules/{alertsSuppressionRuleName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="alertsSuppressionRuleName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AlertsSuppressionRulesList>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

