/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.AlertsSuppressionRulesClient;
import com.azure.resourcemanager.security.fluent.models.AlertsSuppressionRuleInner;
import com.azure.resourcemanager.security.implementation.AlertsSuppressionRuleImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.AlertsSuppressionRule;
import com.azure.resourcemanager.security.models.AlertsSuppressionRules;

public final class AlertsSuppressionRulesImpl
implements AlertsSuppressionRules {
    private static final ClientLogger LOGGER = new ClientLogger(AlertsSuppressionRulesImpl.class);
    private final AlertsSuppressionRulesClient innerClient;
    private final SecurityManager serviceManager;

    public AlertsSuppressionRulesImpl(AlertsSuppressionRulesClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<AlertsSuppressionRule> list() {
        PagedIterable<AlertsSuppressionRuleInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertsSuppressionRuleImpl((AlertsSuppressionRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AlertsSuppressionRule> list(String alertType, Context context) {
        PagedIterable<AlertsSuppressionRuleInner> inner = this.serviceClient().list(alertType, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AlertsSuppressionRuleImpl((AlertsSuppressionRuleInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AlertsSuppressionRule> getWithResponse(String alertsSuppressionRuleName, Context context) {
        Response<AlertsSuppressionRuleInner> inner = this.serviceClient().getWithResponse(alertsSuppressionRuleName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertsSuppressionRuleImpl((AlertsSuppressionRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AlertsSuppressionRule get(String alertsSuppressionRuleName) {
        AlertsSuppressionRuleInner inner = this.serviceClient().get(alertsSuppressionRuleName);
        if (inner != null) {
            return new AlertsSuppressionRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<AlertsSuppressionRule> updateWithResponse(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule, Context context) {
        Response<AlertsSuppressionRuleInner> inner = this.serviceClient().updateWithResponse(alertsSuppressionRuleName, alertsSuppressionRule, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AlertsSuppressionRuleImpl((AlertsSuppressionRuleInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AlertsSuppressionRule update(String alertsSuppressionRuleName, AlertsSuppressionRuleInner alertsSuppressionRule) {
        AlertsSuppressionRuleInner inner = this.serviceClient().update(alertsSuppressionRuleName, alertsSuppressionRule);
        if (inner != null) {
            return new AlertsSuppressionRuleImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String alertsSuppressionRuleName, Context context) {
        return this.serviceClient().deleteWithResponse(alertsSuppressionRuleName, context);
    }

    @Override
    public void delete(String alertsSuppressionRuleName) {
        this.serviceClient().delete(alertsSuppressionRuleName);
    }

    private AlertsSuppressionRulesClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }
}

