/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Application;
import com.azure.resourcemanager.security.models.ApplicationSourceResourceType;
import java.util.Collections;
import java.util.List;

public final class ApplicationImpl
implements Application,
Application.Definition,
Application.Update {
    private ApplicationInner innerObject;
    private final SecurityManager serviceManager;
    private String applicationId;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String displayName() {
        return this.innerModel().displayName();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public ApplicationSourceResourceType sourceResourceType() {
        return this.innerModel().sourceResourceType();
    }

    @Override
    public List<Object> conditionSets() {
        List<Object> inner = this.innerModel().conditionSets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public ApplicationInner innerModel() {
        return this.innerObject;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public Application create() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().createOrUpdateWithResponse(this.applicationId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Application create(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().createOrUpdateWithResponse(this.applicationId, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationImpl(String name, SecurityManager serviceManager) {
        this.innerObject = new ApplicationInner();
        this.serviceManager = serviceManager;
        this.applicationId = name;
    }

    @Override
    public ApplicationImpl update() {
        return this;
    }

    @Override
    public Application apply() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().createOrUpdateWithResponse(this.applicationId, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public Application apply(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().createOrUpdateWithResponse(this.applicationId, this.innerModel(), context).getValue());
        return this;
    }

    ApplicationImpl(ApplicationInner innerObject, SecurityManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.applicationId = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "applications");
    }

    @Override
    public Application refresh() {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().getWithResponse(this.applicationId, Context.NONE).getValue());
        return this;
    }

    @Override
    public Application refresh(Context context) {
        this.innerObject = (ApplicationInner)((Object)this.serviceManager.serviceClient().getApplicationOperations().getWithResponse(this.applicationId, context).getValue());
        return this;
    }

    @Override
    public ApplicationImpl withDisplayName(String displayName) {
        this.innerModel().withDisplayName(displayName);
        return this;
    }

    @Override
    public ApplicationImpl withDescription(String description) {
        this.innerModel().withDescription(description);
        return this;
    }

    @Override
    public ApplicationImpl withSourceResourceType(ApplicationSourceResourceType sourceResourceType) {
        this.innerModel().withSourceResourceType(sourceResourceType);
        return this;
    }

    @Override
    public ApplicationImpl withConditionSets(List<Object> conditionSets) {
        this.innerModel().withConditionSets(conditionSets);
        return this;
    }
}

