/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.security.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.security.SecurityManager;
import com.azure.resourcemanager.security.fluent.ApplicationOperationsClient;
import com.azure.resourcemanager.security.fluent.models.ApplicationInner;
import com.azure.resourcemanager.security.implementation.ApplicationImpl;
import com.azure.resourcemanager.security.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.security.models.Application;
import com.azure.resourcemanager.security.models.ApplicationOperations;

public final class ApplicationOperationsImpl
implements ApplicationOperations {
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationOperationsImpl.class);
    private final ApplicationOperationsClient innerClient;
    private final SecurityManager serviceManager;

    public ApplicationOperationsImpl(ApplicationOperationsClient innerClient, SecurityManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Application> getWithResponse(String applicationId, Context context) {
        Response<ApplicationInner> inner = this.serviceClient().getWithResponse(applicationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationImpl((ApplicationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Application get(String applicationId) {
        ApplicationInner inner = this.serviceClient().get(applicationId);
        if (inner != null) {
            return new ApplicationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String applicationId, Context context) {
        return this.serviceClient().deleteWithResponse(applicationId, context);
    }

    @Override
    public void delete(String applicationId) {
        this.serviceClient().delete(applicationId);
    }

    @Override
    public Application getById(String id) {
        String applicationId = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return (Application)this.getWithResponse(applicationId, Context.NONE).getValue();
    }

    @Override
    public Response<Application> getByIdWithResponse(String id, Context context) {
        String applicationId = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return this.getWithResponse(applicationId, context);
    }

    @Override
    public void deleteById(String id) {
        String applicationId = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        this.deleteWithResponse(applicationId, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String applicationId = ResourceManagerUtils.getValueFromIdByName(id, "applications");
        if (applicationId == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'applications'.", id)));
        }
        return this.deleteWithResponse(applicationId, context);
    }

    private ApplicationOperationsClient serviceClient() {
        return this.innerClient;
    }

    private SecurityManager manager() {
        return this.serviceManager;
    }

    @Override
    public ApplicationImpl define(String name) {
        return new ApplicationImpl(name, this.manager());
    }
}

